/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.websocket.serivces;

import com.simba.common.log.LogUtil;
import com.simba.common.websocket.WebSocketChannelManager;
import com.simba.common.websocket.service.WebSocketService;
import com.simba.server.components.ChannelsManager;
import com.simba.server.components.WebUserInfoManager;
import com.simba.server.components.data.WebUserInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class UserLoginWebSocketService
implements WebSocketService {
    public static final String NAME = "UserLogin";
    private static final Logger logger = Logger.getLogger(UserLoginWebSocketService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = new JSONObject(content.toString());
            String Username = request.getString("Username");
            WebUserInfo webUserInfo = WebUserInfoManager.getInstance().getWebUserInfo(Username);
            if (webUserInfo == null) {
                return;
            }
            boolean loginStatus = false;
            String Password = request.getString("Password");
            JSONObject requestObj = new JSONObject();
            requestObj.put("ServiceName", NAME);
            if (webUserInfo.getPwd().equals(Password)) {
                loginStatus = true;
                if (!ChannelsManager.getInstance().containsWebSocketClient(channel)) {
                    ChannelsManager.getInstance().addWebSocketClients(channel);
                } else {
                    ChannelsManager.getInstance().updateWebSocketTime(channel);
                }
                requestObj.put("Result", "Success");
                requestObj.put("Permissions", webUserInfo.getAuthority());
                WebSocketChannelManager.getInstance().commitResponse(channel, requestObj.toString(), false);
            } else {
                requestObj.put("Result", "Failure");
                WebSocketChannelManager.getInstance().commitResponse(channel, requestObj.toString(), false);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String strTime = sdf.format(new Date());
            LogUtil.LogDebug(logger, "[UserLoginWebSocketService] Username: " + Username + " ServerTime: " + strTime + " LoginStatus: " + loginStatus);
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "[UserLoginWebSocketService] Catch Exception : :" + ex.toString());
        }
    }
}

