/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice;

import com.simba.common.RequestHandler;
import com.simba.common.jsonservice.DefaultJsonServiceContainer;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.jsonservice.JsonServiceContainer;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.jsonservice.serivces.EchoJsonService;
import com.simba.server.jsonservice.serivces.ErrorJsonService;
import com.simba.server.jsonservice.serivces.HeartbeatService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonServiceManager
implements RequestHandler {
    public static final String JSON_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(JsonServiceManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Json-Service-Task";
    private Executor asyncJsonServiceExecutor;
    private BlockingQueue<Runnable> asyncJsonServiceOperationQueue;
    private final JsonServiceContainer container = new DefaultJsonServiceContainer();

    public static JsonServiceManager getInstance() {
        return JsonServiceManagerHolder.INSTANCE;
    }

    private JsonServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final byte[] request = (byte[])requestObj;
        this.runAsyncJsonTask(new Runnable(){

            @Override
            public void run() {
                block6: {
                    JsonService accessor = null;
                    try {
                        JSONObject requestJSONObject = JsonServiceManager.this.parseServiceJsonData(request);
                        if (requestJSONObject == null) {
                            return;
                        }
                        String serviceName = requestJSONObject.getString(JsonServiceManager.JSON_SERVICE_NAME);
                        if (serviceName == null) {
                            return;
                        }
                        accessor = JsonServiceManager.this.container.getJsonService(serviceName);
                        if (accessor == null) {
                            accessor = JsonServiceManager.this.container.getJsonService("Error");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, requestJSONObject);
                        }
                    }
                    catch (Exception ex) {
                        LogUtil.LogError(logger, "[JonServiceManager.handleRequest] Catch an Exception:" + ex.toString());
                        if (!(ex instanceof InterruptedException)) break block6;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    public void init() {
        this.initJsonServiceContainer();
        this.initAsyncJsonTaskExcutor();
    }

    public void postInitProcess() {
        LogUtil.LogDebug(logger, "[JsonServiceManager.postInitProcess] Initialize successfully.");
    }

    private void initAsyncJsonTaskExcutor() {
        this.asyncJsonServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncJsonServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncJsonServiceOperationQueue);
    }

    private void initJsonServiceContainer() {
        this.container.addJsonService("Echo", new EchoJsonService());
        this.container.addJsonService("Error", new ErrorJsonService());
        this.container.addJsonService("JsonHeartBeat", new HeartbeatService());
    }

    private JSONObject parseServiceJsonData(byte[] request) {
        JSONObject requestJSONObject = null;
        try {
            String jsonString = new String(request, "UTF-8");
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            requestJSONObject = (JSONObject)jsonTokener.nextValue();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[JsonServiceManager.parseServiceJsonData] Parse Json service name Exception :" + ex.toString());
            requestJSONObject = null;
        }
        return requestJSONObject;
    }

    private void runAsyncJsonTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncJsonServiceExecutor.execute(task);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[JsonServiceManager.runAsyncJsonTask]  Run async task to access json service request failed : " + ex.toString());
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class JsonServiceManagerHolder {
        private static final JsonServiceManager INSTANCE = new JsonServiceManager();

        private JsonServiceManagerHolder() {
        }
    }
}

