/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.components.FrameUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlcStatusDecoder
implements Decoder {
    public static final String NAME = "PlcStatusDecoder";
    protected static final Logger logger = Logger.getLogger(PlcStatusDecoder.class);
    private static final int TIME_BUFFER_POSITION = 3;

    public static PlcStatusDecoder getInstance() {
        return PlcStatusDecoderHolder.INSTANCE;
    }

    private PlcStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            long plcTime = FrameUtils.getInstance().getLongBigEndian(3, content);
            long now = System.currentTimeMillis();
            this.sendToRemoteLogger(plcTime, now);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[EchoTimeDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemoteLogger(long plcTime, long now) {
        JSONObject echoTime = new JSONObject();
        String delta = String.valueOf(now - plcTime) + "ms";
        echoTime.put("ServiceName", "EchoTime");
        echoTime.put("plcTime", plcTime);
        echoTime.put("serverTime", now);
        echoTime.put("delta", delta);
        String echoTimeStr = echoTime.toString();
        for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, echoTimeStr.getBytes(), false);
        }
    }

    private static class PlcStatusDecoderHolder {
        private static final PlcStatusDecoder INSTANCE = new PlcStatusDecoder();

        private PlcStatusDecoderHolder() {
        }
    }
}

