/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.FrameUtils;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class ChuteStatusDecoder
implements Decoder {
    public static final String NAME = "ChuteStatusDecoder";
    protected static final Logger logger = Logger.getLogger(ChuteStatusDecoder.class);
    private static final int CHUTE_NUM_POSITION = 3;
    private static final int EACH_CHUTE_POSITION = 5;

    public static ChuteStatusDecoder getInstance() {
        return SlotStatusDecoderHolder.INSTANCE;
    }

    private ChuteStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            InetSocketAddress socketAddress = (InetSocketAddress)channel.getRemoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
            if (crossSorterInfo == null) {
                return;
            }
            byte[] content = (byte[])message;
            int totalStatus = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            int position = 5;
            String strStatus = "";
            for (int i = 1; i <= totalStatus; ++i) {
                byte intStatus = content[position];
                strStatus = strStatus + intStatus + ",";
                ++position;
            }
            if (strStatus.length() > 2) {
                strStatus = strStatus.substring(0, strStatus.length() - 1);
                this.sendToRemote(strStatus, crossSorterInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[ChuteStatusDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    private void sendToRemote(String strStatus, CrossSorterInfo crossSorterInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "Chute");
        sendObj.put("Machine", crossSorterInfo.getSorterName());
        sendObj.put("Layer", crossSorterInfo.getSorterLayer());
        sendObj.put("Data", strStatus);
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SlotStatusDecoderHolder {
        private static final ChuteStatusDecoder INSTANCE = new ChuteStatusDecoder();

        private SlotStatusDecoderHolder() {
        }
    }
}

