/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder;

import com.simba.common.RequestHandler;
import com.simba.common.decoder.Decoder;
import com.simba.common.decoder.DecoderContainer;
import com.simba.common.decoder.DefaultDecoderContainer;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.common.utils.StringUtil;
import com.simba.server.ServerParam;
import com.simba.server.components.CommonProtocolDefines;
import com.simba.server.components.SorterParameter;
import com.simba.server.framedecoder.decoders.CarStatusDecoder;
import com.simba.server.framedecoder.decoders.ChuteStatusDecoder;
import com.simba.server.framedecoder.decoders.EchoTimeDecoder;
import com.simba.server.framedecoder.decoders.EmergencyStatusDecoder;
import com.simba.server.framedecoder.decoders.MachineStatusDecoder;
import com.simba.server.framedecoder.decoders.MotorStatusDecoder;
import com.simba.server.framedecoder.decoders.PlatStatusDecoder;
import com.simba.server.framedecoder.decoders.PlcStatusDecoder;
import com.simba.server.framedecoder.rocker.RockerAlarmUploadDecoder;
import com.simba.server.framedecoder.rocker.RockerKeepAliveDecoder;
import com.simba.server.framedecoder.rocker.RockerStatusDecoder;
import com.simba.server.framedecoder.wheel.TestWheelPacketOffDecoder;
import com.simba.server.framedecoder.wheel.TestWheelPacketOnDecoder;
import com.simba.server.framedecoder.wheel.WheelAlarmUploadDecoder;
import com.simba.server.framedecoder.wheel.WheelKeepAliveDecoder;
import com.simba.server.framedecoder.wheel.WheelStatusDecoder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class FrameDecoderManager
implements RequestHandler {
    protected static final Logger logger = Logger.getLogger(FrameDecoderManager.class);
    private static int ASYNC_EXECUTOR_POOL_SIZE = 8;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Frame-Decode-Task";
    private Executor asyncDecodeExecutor;
    private BlockingQueue<Runnable> asyncDecodeOperationQueue;
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();

    public static FrameDecoderManager getInstance() {
        return FrameDecoderManagerHolder.INSTANCE;
    }

    private FrameDecoderManager() {
    }

    @Override
    public void handleRequest(final Channel channel, final Object message) {
        Runnable executeRunnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (!(message instanceof byte[])) {
                            LogUtil.LogInfo(logger, "[FrameDecoderManager.handleRequest]  Message is not instance of byte[]. ");
                            FrameChannelManager.getInstance().commitResponse(channel, CommonProtocolDefines.ERROR_MESSAGE, true);
                            return;
                        }
                        byte[] content = (byte[])message;
                        if (content[0] != 1) {
                            this.printCurrentChannel(channel);
                            channel.disconnect();
                            return;
                        }
                        this.printChannel(channel, content);
                        byte command = content[2];
                        Decoder frameDecoder = FrameDecoderManager.this.getDecoderByCommandNum(command);
                        if (frameDecoder != null) {
                            frameDecoder.doDecode(channel, message);
                        }
                    }
                    catch (Exception ex) {
                        LogUtil.LogError(logger, "[FrameDecoderManager.handleRequest] catch exception : " + ex.toString());
                        if (!(ex instanceof InterruptedException)) break block5;
                        Thread.currentThread().interrupt();
                    }
                }
            }

            private void printCurrentChannel(Channel channel2) {
                try {
                    StringBuilder info = new StringBuilder(256);
                    info.append("[FrameDecoderManager.printCurrentChannel]:");
                    info.append("[Disconnect channel, Message format is incorrect. ");
                    info.append("Channel Iofo:").append(channel2).append("]");
                    String content = info.toString();
                    LogUtil.LogDebug(logger, content);
                }
                catch (Exception ex) {
                    LogUtil.LogError(logger, "[FrameDecoderManager.printCurrentChannel] Catch an Exception:" + ex.toString());
                }
            }

            private void printChannel(Channel channel2, byte[] content) {
                try {
                    String strPrintContent = StringUtil.byteToHexString(content);
                    String logInfo = "[FrameDecoderManager.RecvMessage] [" + channel2.getRemoteAddress() + "] -- " + strPrintContent;
                    LogUtil.LogDebug(logger, logInfo);
                }
                catch (Exception ex) {
                    LogUtil.LogError(logger, "[FrameDecoderManager.printChannel] Catch an Exception:" + ex.toString());
                }
            }
        };
        if (SorterParameter.getInstance().isNewThreadEachRequest()) {
            this.executeInNewThread(executeRunnable);
        } else {
            this.executeInThreadPool(executeRunnable);
        }
    }

    public void init() {
        this.initAsyncTaskExcutor();
        this.initDecoderContainer();
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    public void postInitProcess() {
        String requestMode = "Request In New Thread";
        if (!SorterParameter.getInstance().isNewThreadEachRequest()) {
            requestMode = "Request In Thread Pool";
        }
        LogUtil.LogDebug(logger, "[FrameDecoderManager.postInitProcess] Initialize successfully, Pool size:[" + ASYNC_EXECUTOR_POOL_SIZE + "] reqeust mode:[" + requestMode + "]");
    }

    protected Decoder getDecoderByCommandNum(byte command) {
        Decoder frameDecoder = null;
        switch (command) {
            case 17: {
                frameDecoder = this.decoderContainer.getDecoder("EchoTime");
                break;
            }
            case 48: {
                frameDecoder = this.decoderContainer.getDecoder("CarStatus");
                break;
            }
            case 49: {
                frameDecoder = this.decoderContainer.getDecoder("ChuteStatusDecoder");
                break;
            }
            case 50: {
                frameDecoder = this.decoderContainer.getDecoder("PlatStatusDecoder");
                break;
            }
            case 51: {
                frameDecoder = this.decoderContainer.getDecoder("EmergencyStatus");
                break;
            }
            case 52: {
                frameDecoder = this.decoderContainer.getDecoder("MotorStatusDecoder");
                break;
            }
            case 53: {
                frameDecoder = this.decoderContainer.getDecoder("PlcStatusDecoder");
                break;
            }
            case 54: {
                frameDecoder = this.decoderContainer.getDecoder("MachineStatus");
                break;
            }
            case 96: {
                frameDecoder = this.decoderContainer.getDecoder("RockerKeepAlive");
                break;
            }
            case 97: {
                frameDecoder = this.decoderContainer.getDecoder("RockerStatus");
                break;
            }
            case 98: {
                break;
            }
            case 99: {
                frameDecoder = this.decoderContainer.getDecoder("RockerAlarmUpload");
                break;
            }
            case 112: {
                frameDecoder = this.decoderContainer.getDecoder("Wheel-KeepAlive-Decoder");
                break;
            }
            case 113: {
                frameDecoder = this.decoderContainer.getDecoder("RockerStatus");
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                frameDecoder = this.decoderContainer.getDecoder("RockerAlarmUpload");
                break;
            }
            case 2: {
                frameDecoder = this.decoderContainer.getDecoder("TestWheelPacketOnDecoder");
                break;
            }
            case 5: {
                frameDecoder = this.decoderContainer.getDecoder("TestWheelPacketOffDecoder");
                break;
            }
        }
        return frameDecoder;
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncDecodeTask(executeRunnable);
    }

    private void initAsyncTaskExcutor() {
        if (ServerParam.DECODER_THREAD_POOL_SIZE > 0) {
            ASYNC_EXECUTOR_POOL_SIZE = ServerParam.DECODER_THREAD_POOL_SIZE;
        }
        this.asyncDecodeOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncDecodeExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncDecodeOperationQueue);
    }

    private void initDecoderContainer() {
        this.decoderContainer.addDecoder("EchoTime", EchoTimeDecoder.getInstance());
        this.decoderContainer.addDecoder("CarStatus", CarStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("ChuteStatusDecoder", ChuteStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("PlatStatusDecoder", PlatStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("EmergencyStatus", EmergencyStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("MotorStatusDecoder", MotorStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("MachineStatus", MachineStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("PlcStatusDecoder", PlcStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("RockerKeepAlive", RockerKeepAliveDecoder.getInstance());
        this.decoderContainer.addDecoder("RockerStatus", RockerStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("RockerAlarmUpload", RockerAlarmUploadDecoder.getInstance());
        this.decoderContainer.addDecoder("TestWheelPacketOnDecoder", TestWheelPacketOnDecoder.getInstance());
        this.decoderContainer.addDecoder("TestWheelPacketOffDecoder", TestWheelPacketOffDecoder.getInstance());
        this.decoderContainer.addDecoder("Wheel-KeepAlive-Decoder", WheelKeepAliveDecoder.getInstance());
        this.decoderContainer.addDecoder("RockerStatus", WheelStatusDecoder.getInstance());
        this.decoderContainer.addDecoder("RockerAlarmUpload", WheelAlarmUploadDecoder.getInstance());
    }

    private void runAsyncDecodeTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncDecodeExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[FrameDecoderManager.runAsyncDecodeTask] Run async task to decode failed : " + e.getMessage());
        }
    }

    private static class FrameDecoderManagerHolder {
        private static final FrameDecoderManager INSTANCE = new FrameDecoderManager();

        private FrameDecoderManagerHolder() {
        }
    }
}

