/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.websocket.WebSocketChannelManager;
import com.simba.server.components.ChannelsManager;
import com.simba.server.components.data.KeepAliveInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class TestMsgThread
extends Thread {
    private static final Logger logger = Logger.getLogger(TestMsgThread.class);
    private static final int RECONNECT_INTERVAL = 1000;

    public TestMsgThread() {
        this.setName("Test-Msg-Thread");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void TestSendWebSocketMsg() {
        try {
            Thread.sleep(100L);
            JSONObject carObj = this.getTestStatus("Car", 60, 9);
            this.SendToClients(carObj);
            Thread.sleep(100L);
            JSONObject chuteObj = this.getTestStatus("Chute", 40, 3);
            this.SendToClients(chuteObj);
            Thread.sleep(100L);
            JSONObject emergencyObj = this.getTestStatus("Emergency", 8, 2);
            this.SendToClients(emergencyObj);
            Thread.sleep(100L);
            JSONObject platObj = this.getTestStatus("Plat", 12, 7);
            this.SendToClients(platObj);
            Thread.sleep(100L);
            JSONObject motorObj = this.getTestStatus("Motor", 12, 5);
            this.SendToClients(motorObj);
            Thread.sleep(100L);
            JSONObject grayObj = this.getTestStatus("GrayScanner", 8, 2);
            this.SendToClients(grayObj);
            Thread.sleep(100L);
            JSONObject obrObj = this.getTestStatus("OBRScanner", 4, 2);
            this.SendToClients(obrObj);
            Thread.sleep(100L);
            JSONObject sendObj = new JSONObject();
            sendObj.put("ServiceName", "PlcStatus");
            sendObj.put("Machine", "1");
            sendObj.put("Layer", "1");
            sendObj.put("Status", "1");
            sendObj.put("Model", "0");
            sendObj.put("Speed", "1.5");
            this.SendToClients(sendObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void SendToClients(JSONObject sendObj) {
        for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, sendObj.toString().getBytes(), false);
        }
        for (KeepAliveInfo keepAliveInfo : ChannelsManager.getInstance().getWebSocketChannels()) {
            WebSocketChannelManager.getInstance().commitResponse(keepAliveInfo.getChannel(), sendObj.toString(), false);
        }
    }

    private JSONObject getTestStatus(String name, int statusNum, int maxStatus) {
        String strStatus = "";
        for (int n = 0; n <= statusNum; ++n) {
            int intCarStatusCache = (int)(Math.random() * (double)maxStatus);
            strStatus = strStatus + intCarStatusCache + ",";
        }
        strStatus = strStatus.substring(0, strStatus.length() - 1);
        JSONObject requestObj = new JSONObject();
        requestObj.put("ServiceName", name);
        requestObj.put("Machine", "1");
        requestObj.put("Layer", "1");
        requestObj.put("Data", strStatus);
        return requestObj;
    }
}

