/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.WebUserInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class WebUserInfoManager {
    protected static final Logger logger = Logger.getLogger(WebUserInfoManager.class);
    private final ConcurrentHashMap<String, WebUserInfo> webUserList = new ConcurrentHashMap();

    public static WebUserInfoManager getInstance() {
        return WebUserInfoManagerHolder.INSTANCE;
    }

    private WebUserInfoManager() {
    }

    public WebUserInfo getWebUserInfo(String webUser) {
        WebUserInfo webUserinfo = this.webUserList.get(webUser);
        return webUserinfo;
    }

    public boolean CheckWorkNumberIsAvailable(String webUser) {
        return this.webUserList.containsKey(webUser);
    }

    public void RemoveWorkNumberKeyStatus(String webUser) {
        this.webUserList.remove(webUser);
    }

    public void AddWorkNumberKey(WebUserInfo webUserInfo) {
        this.webUserList.put(webUserInfo.getUser(), webUserInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RenewHandle(ConcurrentHashMap<String, WebUserInfo> webUserList) {
        ConcurrentHashMap<String, WebUserInfo> concurrentHashMap = webUserList;
        synchronized (concurrentHashMap) {
            this.webUserList.clear();
            this.webUserList.putAll(webUserList);
        }
    }

    public void init() {
        this.RenewWebUserList();
    }

    public void RenewWebUserList() {
        ConcurrentHashMap<String, WebUserInfo> webUserList = new ConcurrentHashMap<String, WebUserInfo>();
        WebUserInfo webUserInfo = new WebUserInfo();
        webUserInfo.setUserStatus(1);
        webUserList.put("param", webUserInfo);
        ICommand command = CommandCreator.getInstance().createCommand("FetchWebUserListCmd", webUserList);
        boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (!ret) {
            LogUtil.LogDebug(logger, "[WebUserInfoManager.RenewWebUserList] Fetch User error! ");
            return;
        }
        if (webUserList != null) {
            this.RenewHandle(webUserList);
        }
    }

    private static class WebUserInfoManagerHolder {
        private static final WebUserInfoManager INSTANCE = new WebUserInfoManager();

        private WebUserInfoManagerHolder() {
        }
    }
}

