/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.sql;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import java.util.List;

public class SQLBatchAddCmd
implements ICommand {
    public static final String NAME = "SQLBatchAddCmd";
    private final List<String> boxInfos;
    private final String sql = "insert into tt_box_info(slotId, chuteCode, boxCode, boxType, receiveSiteCode,receiveSiteName, createSiteName, router, routerNum, categoryText, mixBoxTypeText) values (?,?,?,?,?,?,?,?,?,?,?)";

    public SQLBatchAddCmd(List<String> slotIPacknfos) {
        this.boxInfos = slotIPacknfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.clearParameters();
            dbOperator.prepareStatement(this.sql);
            dbOperator.setAutoCommit(false);
            for (String boxInfo : this.boxInfos) {
                dbOperator.setString(1, boxInfo);
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            if (rs == null || rs.length <= 0) {
                return ret;
            }
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

