/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.sql;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.WarningInfo;
import java.sql.Timestamp;

public class RecordWarningInfoCmd
implements ICommand {
    public static final String NAME = "RecordWarningInfoCmd";
    private final WarningInfo warningInfo;
    private final String sql = "insert into tt_warning_info_history(level, module, moduleId, message, recordDate) values (?,?,?,?,?)";

    public RecordWarningInfoCmd(WarningInfo warningInfo) {
        this.warningInfo = warningInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            int level = this.warningInfo.getLevel();
            dbOperator.setInt(1, level);
            String module = this.warningInfo.getModule();
            if (module == null || module.equals("")) {
                module = "unknown";
            }
            dbOperator.setString(2, module);
            int moduleId = this.warningInfo.getModuleId();
            dbOperator.setInt(3, moduleId);
            String message = this.warningInfo.getMessage();
            if (message == null || message.equals("")) {
                message = "none";
            }
            dbOperator.setString(4, message);
            Timestamp scannedTime = this.warningInfo.getRecordDate();
            if (scannedTime == null) {
                scannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(5, scannedTimeContent);
            int res = dbOperator.executeUpdate();
            if (res > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

