/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands;

import com.simba.common.command.ICommand;
import com.simba.server.commands.impl.sql.FetchWebUserListCmd;
import com.simba.server.commands.impl.sql.RecordWarningInfoCmd;
import com.simba.server.commands.impl.sql.SqlCmd;
import com.simba.server.commands.impl.sql.TestRecordPacketOffCmd;
import com.simba.server.commands.impl.web.WebCmd;
import com.simba.server.components.data.DBDataInfos;
import com.simba.server.components.data.WarningInfo;
import com.simba.server.components.data.WheelSortInfo;
import java.util.concurrent.ConcurrentHashMap;

public class CommandCreator {
    public static CommandCreator getInstance() {
        return CommandCreatorHolder.INSTANCE;
    }

    private CommandCreator() {
    }

    public ICommand createCommand(String cmdName, Object paramsObj) {
        ICommand command = null;
        switch (cmdName) {
            case "SQLBatchAddCmd": {
                command = new SqlCmd((DBDataInfos)paramsObj);
                break;
            }
            case "FetchWebUserListCmd": {
                command = new FetchWebUserListCmd((ConcurrentHashMap)paramsObj);
                break;
            }
            case "RecordWarningInfoCmd": {
                command = new RecordWarningInfoCmd((WarningInfo)paramsObj);
                break;
            }
            case "TestRecordPacketOffCmd": {
                command = new TestRecordPacketOffCmd((WheelSortInfo)paramsObj);
                break;
            }
            case "WebCmd": {
                command = new WebCmd((DBDataInfos)paramsObj);
                break;
            }
        }
        return command;
    }

    private static class CommandCreatorHolder {
        private static CommandCreator INSTANCE = new CommandCreator();

        private CommandCreatorHolder() {
        }
    }
}

