/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.GlobalParam;
import com.simba.common.DefaultServerInfo;
import com.simba.common.log.LogHelper;
import com.simba.server.ServerManager;
import com.simba.server.components.SorterParameter;
import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;

public class ServerParam {
    public static String CONFIG_XML_FILE = "etc" + GlobalParam.PATH_SEP + "simba-server-config.xml";
    public static int DECODER_THREAD_POOL_SIZE = 10;
    public static int IO_THREAD_POOL_SIZE = 5;
    public static int EVENT_THREAD_POOL_SIZE = 5;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static boolean IS_WINDOWS_SERVER = false;
    public static String NEED_DEBUG = "false";
    public static final String SERVER_VERSION = "1.0";
    public static String LOG_PATH = "logs";
    public static String ERROR_LOG = "error.log";
    public static String ACCESS_LOG = "access.log";
    public static String VERBOSE_LOG = "verbose.log";
    private static DefaultServerInfo serverInfo;
    public static String DefaultPadServerAddress;
    public static int DefaultPadServerPort;

    public static DefaultServerInfo getServerInfo() {
        return serverInfo;
    }

    public static void initGlobalConfiguration() {
        try {
            String os = System.getProperty("os.name");
            IS_WINDOWS_SERVER = os.substring(0, 3).equalsIgnoreCase("win");
            serverInfo = new DefaultServerInfo();
            Document rootMessage = ServerManager.getInstance().getXmlDocFromFile(new File(CONFIG_XML_FILE));
            Element rootElement = rootMessage.getRootElement();
            ServerParam.initConnectionSectionConfiguration(rootElement);
            ServerParam.initGlobalSectionConfiguration(rootElement);
        }
        catch (Exception ex) {
            System.out.println("Init global server configuration " + CONFIG_XML_FILE + " error: " + ex.toString());
            System.out.println("Server Started failed");
            System.exit(5000);
        }
    }

    public static void initRootLogger(String configFile) {
        File fp = new File(LOG_PATH);
        if (fp.exists()) {
            boolean canWrite = fp.canWrite();
            if (!canWrite) {
                System.out.println("Fatal Error: Log path: " + LOG_PATH + " can't write");
                System.exit(5000);
            }
        } else if (!fp.mkdir()) {
            System.out.println("Fatal Error: Data path: " + LOG_PATH + " can't create");
            System.exit(5000);
        }
        String accessLogPath = LOG_PATH + GlobalParam.PATH_SEP + ACCESS_LOG;
        String errorLogPath = LOG_PATH + GlobalParam.PATH_SEP + ERROR_LOG;
        String verboseLogPath = LOG_PATH + GlobalParam.PATH_SEP + VERBOSE_LOG;
        try {
            LogHelper.configure(configFile, verboseLogPath, accessLogPath, errorLogPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printStartedInfo() {
        System.out.println("\t");
        System.out.println("Simba Server has been Started!");
        System.out.println("*******************************************");
        System.out.println("*                                         *");
        System.out.println("*                                         *");
        System.out.println("*       Simba-General-Monitor-Server      *");
        System.out.println("*                                         *");
        System.out.println("*                                         *");
        System.out.println("*******************************************");
        System.out.println("\t");
    }

    public static String replaceSlash(String path) {
        String result = path;
        result = GlobalParam.PATH_SEP.equals("\\") ? result.replaceAll("/", "\\\\") : result.replaceAll("\\\\", "/");
        if (result.substring(result.length() - 1).equals(GlobalParam.PATH_SEP)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static void initConnectionSectionConfiguration(Element rootElement) {
        try {
            Element connElement = rootElement.getChild("Connection");
            String frameServerAddress = connElement.getChild("frame-sorter-server").getAttribute("ip").getValue();
            serverInfo.setDefaultServerAddress(frameServerAddress);
            serverInfo.setDefaultServerPort(Integer.parseInt(connElement.getChild("frame-sorter-server").getAttribute("port").getValue()));
            String jsonServerAddress = connElement.getChild("json-content-server").getAttribute("ip").getValue();
            serverInfo.setJsonServerAddress(jsonServerAddress);
            serverInfo.setJsonServerPort(Integer.parseInt(connElement.getChild("json-content-server").getAttribute("port").getValue()));
            String websocketServerAddress = connElement.getChild("websocket-content-server").getAttribute("ip").getValue();
            serverInfo.setHttpServerAddress(websocketServerAddress);
            serverInfo.setHttpServerPort(Integer.parseInt(connElement.getChild("websocket-content-server").getAttribute("port").getValue()));
        }
        catch (Exception ex) {
            System.out.println("[ServerParam.initConnectionSectionConfiguration] Catch an Exception:" + ex.toString());
            System.exit(5000);
        }
    }

    private static void initGlobalSectionConfiguration(Element rootElement) throws Exception {
        try {
            Element globalElement = rootElement.getChild("Global");
            EVENT_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("event-threads").getText());
            IO_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("io-workers").getText());
            DECODER_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("decoder-workers").getText());
            LOG_PATH = globalElement.getChild("log-path").getText();
            NEED_DEBUG = globalElement.getChild("need-debug").getText();
            String newThreadEachReq = globalElement.getChild("new-thread-each-request").getText();
            if (newThreadEachReq.equalsIgnoreCase(TRUE_STRING)) {
                SorterParameter.getInstance().setNewThreadEachRequest(true);
            } else {
                SorterParameter.getInstance().setNewThreadEachRequest(false);
            }
            String needDebug = globalElement.getChild("need-debug").getText();
            SorterParameter.getInstance().setNeedDebug(needDebug.equalsIgnoreCase(TRUE_STRING));
            String debugServerHost = globalElement.getChild("debug-server-host").getText();
            if (debugServerHost.equalsIgnoreCase("")) {
                SorterParameter.getInstance().setDebugServerHost("127.0.0.1");
            } else {
                SorterParameter.getInstance().setDebugServerHost(debugServerHost);
            }
            String debugServerPort = globalElement.getChild("debug-server-port").getText();
            if (debugServerPort.equalsIgnoreCase("")) {
                SorterParameter.getInstance().setDebugServerPort("80");
            } else {
                SorterParameter.getInstance().setDebugServerPort(debugServerPort);
            }
            String serverHost = globalElement.getChild("debug-server-host").getText();
            if (serverHost.equalsIgnoreCase("")) {
                SorterParameter.getInstance().setServerHost("127.0.0.1");
            } else {
                SorterParameter.getInstance().setServerHost(serverHost);
            }
            String serverPort = globalElement.getChild("debug-server-port").getText();
            if (serverPort.equalsIgnoreCase("")) {
                SorterParameter.getInstance().setServerPort("80");
            } else {
                SorterParameter.getInstance().setServerPort(serverPort);
            }
        }
        catch (Exception ex) {
            System.out.println("[ServerParam.initGlobalSectionConfiguration] Catch an Exception:" + ex.toString());
            System.exit(5000);
        }
    }

    static {
        DefaultPadServerAddress = "0.0.0.0";
        DefaultPadServerPort = 59000;
    }
}

