/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.GlobalParam;
import com.simba.common.PadFrameserver.PadFrameChannelManager;
import com.simba.common.command.CommandParams;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.database.DbPool;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.frameserver.FrameChannelHandler;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.frameserver.TwoBFrameServer;
import com.simba.common.jsonserver.JsonChannelHandler;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonserver.JsonServer;
import com.simba.common.log.LogHelper;
import com.simba.common.log.LogUtil;
import com.simba.common.processor.FrameProcessor;
import com.simba.common.processor.JsonProcessor;
import com.simba.common.processor.WebSocketProcessor;
import com.simba.common.websocket.WebSocketChannelHandler;
import com.simba.common.websocket.WebSocketChannelManager;
import com.simba.common.websocket.WebSocketServer;
import com.simba.server.ServerParam;
import com.simba.server.components.SorterManager;
import com.simba.server.components.WebUserInfoManager;
import com.simba.server.components.task.ClearOldDBThread;
import com.simba.server.components.task.KeepAliveThread;
import com.simba.server.components.task.TestMsgThread;
import com.simba.server.framedecoder.FrameDecoderManager;
import com.simba.server.jsonservice.JsonServiceManager;
import com.simba.server.websocket.WebServiceManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;

public class ServerManager {
    private static ServerManager instance = new ServerManager();
    private static final String LOG_HEADERS_CONFIG_FILE = "simba-log-header.xml";
    private static final String LOG4J_CONFIG_FILE_DEBUG = "simba-log4j-debug.xml";
    private static final String LOG4J_CONFIG_FILE_VERBOSE = "simba-log4j-verbose.xml";
    private static final Logger logger = Logger.getLogger(ServerManager.class);
    private static final String MYSQL_CONFIG_FILE = "simba-mysql-config.xml";
    private static final String PLC_CROSS_CONFIG_FILE = "simba-plc-config.xml";
    private final ClearOldDBThread clearOldDBTask = new ClearOldDBThread();
    private final KeepAliveThread keepAliveTask = new KeepAliveThread();
    private final TestMsgThread testMsgThread = new TestMsgThread();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private TwoBFrameServer frameServer;
    private WebSocketServer webServer;
    private JsonServer jsonServer;
    private String runMode;
    private final DbPoolInterface mysqlDbPool = new DbPool("simba-mysql-config.xml", "mysql");

    public static ServerManager getInstance() {
        return instance;
    }

    private ServerManager() {
    }

    public String getRunMode() {
        return this.runMode;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public SimpleDateFormat getDateformat() {
        return this.dateFormat;
    }

    public TwoBFrameServer getFrameServer() {
        return this.frameServer;
    }

    public void setFrameServer(TwoBFrameServer frameSorterServer) {
        this.frameServer = frameSorterServer;
    }

    public DbPoolInterface getMysqlDbPool() {
        return this.mysqlDbPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocFromFile(File fp) throws Exception {
        Document xmlDoc = null;
        try {
            SAXBuilder builder = null;
            String driver = "org.apache.crimson.parser.XMLReaderImpl";
            builder = new SAXBuilder(new XMLReaderSAX2Factory(false, driver));
            xmlDoc = builder.build(fp);
        }
        catch (Exception ex) {
            if (xmlDoc == null) {
                throw ex;
            }
        }
        return xmlDoc;
    }

    public void init() {
        this.initParam();
        this.initDatabase();
        this.initServerInstance();
        this.buildAllServers();
        this.startSingleThreadTasks();
        ServerParam.printStartedInfo();
        this.postInitProcess();
    }

    public void initDatabaseMySQL() {
    }

    protected void buildAllServers() {
        this.buildJsonServer();
        this.buildFrameServer();
        this.buildWebSocketServer();
    }

    protected void initParam() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        if (this.runMode.equals("debug")) {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_DEBUG);
        } else {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_VERBOSE);
        }
        ServerParam.initGlobalConfiguration();
    }

    private void buildFrameServer() {
        System.out.println("[Server Init] Starting the frame sorters of frame message ...");
        try {
            FrameProcessor frameMessageProcessor = new FrameProcessor(FrameDecoderManager.getInstance(), FrameChannelManager.getInstance());
            FrameChannelHandler handler = new FrameChannelHandler(frameMessageProcessor);
            this.setFrameServer(new TwoBFrameServer(ServerParam.getServerInfo().getDefaultServerAddress(), ServerParam.getServerInfo().getDefaultServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler));
            this.getFrameServer().start();
            String printInfo = "[Server Init] Starting the frame sorter server on: " + this.getFrameServer().getInetSocketAddress().toString();
            LogUtil.LogInfo(logger, printInfo);
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void buildJsonServer() {
        System.out.println("[Server Init] Starting the json server for service ...");
        try {
            JsonProcessor jsonMessageProcessor = new JsonProcessor(JsonServiceManager.getInstance(), JsonChannelManager.getInstance());
            JsonChannelHandler handler = new JsonChannelHandler(jsonMessageProcessor);
            this.jsonServer = new JsonServer(ServerParam.getServerInfo().getJsonServerAddress(), ServerParam.getServerInfo().getJsonServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.jsonServer.start();
            String printInfo = "[Server Init] Starting the json server on: " + this.jsonServer.getInetSocketAddress().toString();
            LogUtil.LogInfo(logger, printInfo);
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, e.toString());
        }
    }

    private void buildWebSocketServer() {
        System.out.println("[Server Init] Starting the web-socket server for service ...");
        try {
            WebSocketProcessor webSocketProcessor = new WebSocketProcessor(WebServiceManager.getInstance(), WebSocketChannelManager.getInstance());
            WebSocketChannelHandler handler = new WebSocketChannelHandler(webSocketProcessor);
            this.webServer = new WebSocketServer(ServerParam.getServerInfo().getHttpServerAddress(), ServerParam.getServerInfo().getHttpServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.webServer.start();
            String printInfo = "[Server Init] Starting the web-socket server on: " + this.webServer.getInetSocketAddress().toString();
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, e.toString());
        }
    }

    private void initSendHeaders() {
        try {
            Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File("etc" + GlobalParam.PATH_SEP + LOG_HEADERS_CONFIG_FILE));
            Element root = rootDoc.getRootElement();
            Element headersElement = root.getChild("Headers");
            List<Element> headers = headersElement.getChildren();
            for (Element element : headers) {
                String value = element.getAttributeValue("value");
                FrameChannelManager.getInstance().addHeader(value);
                PadFrameChannelManager.getInstance().addHeader(value);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Send headers init error : " + ex.getMessage());
        }
    }

    private void initDatabase() {
        this.initDbPool();
    }

    private void initDbPool() {
        this.mysqlDbPool.init(true);
        SQLCommandExecutor.getInstance().setDbPool(this.mysqlDbPool);
    }

    private void initFrameDecodeManager() {
        FrameDecoderManager.getInstance().init();
    }

    private void initJsonServiceManager() {
        JsonServiceManager.getInstance().init();
    }

    private void initWebScoketManager() {
        WebServiceManager.getInstance().init();
    }

    private void initCommandParams() {
        CommandParams.getInstance().init();
    }

    private void initServerInstance() {
        this.initFrameDecodeManager();
        this.initJsonServiceManager();
        this.initWebScoketManager();
        SorterManager.getInstance().init(PLC_CROSS_CONFIG_FILE);
        this.initCommandParams();
        this.initSendHeaders();
        this.initWebUser();
    }

    private void initWebUser() {
        WebUserInfoManager.getInstance().init();
    }

    private void postInitProcess() {
        FrameDecoderManager.getInstance().postInitProcess();
        JsonServiceManager.getInstance().postInitProcess();
        WebServiceManager.getInstance().postInitProcess();
    }

    private void startSingleThreadTasks() {
        this.keepAliveTask.start();
        this.clearOldDBTask.start();
        this.testMsgThread.start();
    }
}

