/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.admin.CompositeStatisticsListener;
import org.logicalcobwebs.proxool.admin.Snapshot;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.Statistics;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;
import org.logicalcobwebs.proxool.admin.StatisticsLogger;
import org.logicalcobwebs.proxool.admin.StatsRoller;

public class Admin {
    private static final Log LOG = LogFactory.getLog(Admin.class);
    private Log log;
    private Map statsRollers = new HashMap();
    private CompositeStatisticsListener compositeStatisticsListener = new CompositeStatisticsListener();

    public Admin(ConnectionPoolDefinitionIF definition) throws ProxoolException {
        this.log = LogFactory.getLog("org.logicalcobwebs.proxool.stats." + definition.getAlias());
        StringTokenizer st = new StringTokenizer(definition.getStatistics(), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.statsRollers.put(token, new StatsRoller(definition.getAlias(), this.compositeStatisticsListener, token));
        }
        if (definition.getStatisticsLogLevel() != null) {
            this.compositeStatisticsListener.addListener(new StatisticsLogger(this.log, definition.getStatisticsLogLevel()));
        }
    }

    public void addStatisticsListener(StatisticsListenerIF statisticsListener) {
        this.compositeStatisticsListener.addListener(statisticsListener);
    }

    public void connectionReturned(long activeTime) {
        try {
            for (StatsRoller statsRoller : this.statsRollers.values()) {
                statsRoller.connectionReturned(activeTime);
            }
        }
        catch (Throwable e) {
            LOG.error("Stats connectionReturned call failed. Ignoring.", e);
        }
    }

    public void connectionRefused() {
        try {
            for (StatsRoller statsRoller : this.statsRollers.values()) {
                statsRoller.connectionRefused();
            }
        }
        catch (Exception e) {
            LOG.error("Stats connectionRefused call failed. Ignoring.", e);
        }
    }

    public StatisticsIF getStatistics(String token) {
        try {
            return ((StatsRoller)this.statsRollers.get(token)).getCompleteStatistics();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void cancelAll() {
        for (StatsRoller statsRoller : this.statsRollers.values()) {
            statsRoller.cancel();
        }
    }

    public StatisticsIF[] getStatistics() {
        Vector<Statistics> statistics = new Vector<Statistics>();
        for (StatsRoller statsRoller : this.statsRollers.values()) {
            Statistics s = statsRoller.getCompleteStatistics();
            if (s == null) continue;
            statistics.add(s);
        }
        return statistics.toArray(new StatisticsIF[statistics.size()]);
    }

    public static SnapshotIF getSnapshot(ConnectionPoolStatisticsIF cps, ConnectionPoolDefinitionIF cpd, Collection connectionInfos) {
        Snapshot s = new Snapshot(new Date());
        s.setDateStarted(cps.getDateStarted());
        s.setActiveConnectionCount(cps.getActiveConnectionCount());
        s.setAvailableConnectionCount(cps.getAvailableConnectionCount());
        s.setOfflineConnectionCount(cps.getOfflineConnectionCount());
        s.setMaximumConnectionCount(cpd.getMaximumConnectionCount());
        s.setServedCount(cps.getConnectionsServedCount());
        s.setRefusedCount(cps.getConnectionsRefusedCount());
        s.setConnectionInfos(connectionInfos);
        s.setConnectionCount(cps.getConnectionCount());
        return s;
    }
}

