/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;

class FatalSqlExceptionHelper {
    private static final Log LOG = LogFactory.getLog(FatalSqlExceptionHelper.class);

    FatalSqlExceptionHelper() {
    }

    protected static void throwFatalSQLException(String className, Throwable originalException) throws ProxoolException, SQLException, RuntimeException {
        if (className != null && className.trim().length() > 0) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ProxoolException("Couldn't find class " + className);
            }
            if (!SQLException.class.isAssignableFrom(clazz) && !RuntimeException.class.isAssignableFrom(clazz)) {
                throw new ProxoolException("Couldn't wrap up using " + clazz.getName() + " because it isn't either a RuntimeException or an SQLException");
            }
            Constructor<?> toUse = null;
            Object[] args = null;
            String argDescription = "";
            Constructor<?>[] constructors = clazz.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (toUse == null && parameterTypes.length == 0) {
                    toUse = constructor;
                }
                if (parameterTypes.length != 1 || !Exception.class.isAssignableFrom(parameterTypes[0])) continue;
                toUse = constructor;
                args = new Object[]{originalException};
                argDescription = "Exception";
                break;
            }
            try {
                Object exceptionToThrow = toUse.newInstance(args);
                if (exceptionToThrow instanceof RuntimeException) {
                    LOG.debug("Wrapping up a fatal exception: " + originalException.getMessage(), originalException);
                    throw (RuntimeException)exceptionToThrow;
                }
                if (exceptionToThrow instanceof SQLException) {
                    throw (SQLException)exceptionToThrow;
                }
                throw new ProxoolException("Couldn't throw " + clazz.getName() + " because it isn't either a RuntimeException or an SQLException");
            }
            catch (InstantiationException e) {
                throw new ProxoolException("Couldn't create " + clazz.getName() + "(" + argDescription + ")", e);
            }
            catch (IllegalAccessException e) {
                throw new ProxoolException("Couldn't create " + clazz.getName() + "(" + argDescription + ")", e);
            }
            catch (InvocationTargetException e) {
                throw new ProxoolException("Couldn't create " + clazz.getName() + "(" + argDescription + ")", e);
            }
        }
        if (originalException instanceof SQLException) {
            throw (SQLException)originalException;
        }
        if (originalException instanceof RuntimeException) {
            throw (RuntimeException)originalException;
        }
        throw new RuntimeException("Unexpected exception:" + originalException.getMessage());
    }

    protected static boolean testException(ConnectionPoolDefinitionIF cpd, Throwable t) {
        return FatalSqlExceptionHelper.testException(cpd, t, 0);
    }

    protected static boolean testException(ConnectionPoolDefinitionIF cpd, Throwable t, int level) {
        Throwable cause;
        boolean fatalSqlExceptionDetected = false;
        Iterator i = cpd.getFatalSqlExceptions().iterator();
        while (i.hasNext()) {
            if (t.getMessage() == null || t.getMessage().indexOf((String)i.next()) <= -1) continue;
            fatalSqlExceptionDetected = true;
        }
        if (!fatalSqlExceptionDetected && level < 20 && (cause = FatalSqlExceptionHelper.getCause(t)) != null) {
            fatalSqlExceptionDetected = FatalSqlExceptionHelper.testException(cpd, cause, level + 1);
        }
        return fatalSqlExceptionDetected;
    }

    protected static Throwable getCause(Throwable t) {
        Throwable cause = null;
        Method causeMethod = null;
        try {
            if (causeMethod == null) {
                causeMethod = FatalSqlExceptionHelper.getMethod(t, "getCause");
            }
            if (causeMethod == null) {
                causeMethod = FatalSqlExceptionHelper.getMethod(t, "getTargetException");
            }
            if (causeMethod == null) {
                causeMethod = FatalSqlExceptionHelper.getMethod(t, "getRootCause");
            }
            if (causeMethod == null) {
                causeMethod = FatalSqlExceptionHelper.getMethod(t, "getOriginalException");
            }
            if (causeMethod != null) {
                try {
                    cause = (Throwable)causeMethod.invoke((Object)t, null);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Problem invoking " + t.getClass().getName() + "." + causeMethod.getName() + ". Ignoring.", e);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Problem invoking " + t.getClass().getName() + "." + causeMethod.getName() + ". Ignoring.", e);
                }
                catch (InvocationTargetException e) {
                    LOG.warn("Problem invoking " + t.getClass().getName() + "." + causeMethod.getName() + ". Ignoring.", e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception drilling into exception. Ignoring.", e);
        }
        return cause;
    }

    private static Method getMethod(Object o, String methodName) {
        Method m = null;
        try {
            m = o.getClass().getMethod(methodName, null);
            if (!Throwable.class.isAssignableFrom(m.getReturnType())) {
                m = null;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            LOG.warn("Problem finding method " + methodName, e);
        }
        return m;
    }
}

