/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.event.TransportListener;
import javax.mail.search.SearchTerm;

public abstract class Folder {
    public static final int HOLDS_FOLDERS = 2;
    public static final int HOLDS_MESSAGES = 1;
    private static final Message[] MESSAGE_ARRAY = new Message[0];
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    private List _connectionListeners = new LinkedList();
    private List _folderListeners = new LinkedList();
    private List _messageChangedListeners = new LinkedList();
    private List _messageCountListeners = new LinkedList();
    private boolean _subscribed;
    protected int mode;
    protected Store store;

    protected Folder(Store store) {
        this.store = store;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this._connectionListeners.add(listener);
    }

    public void addFolderListener(FolderListener listener) {
        this._folderListeners.add(listener);
    }

    public void addMessageChangedListener(MessageChangedListener listener) {
        this._messageChangedListeners.add(listener);
    }

    public void addMessageCountListener(MessageCountListener listener) {
        this._messageCountListeners.add(listener);
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public void copyMessages(Message[] messages, Folder folder) throws MessagingException {
        folder.appendMessages(messages);
    }

    public abstract boolean create(int var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Message[] expunge() throws MessagingException;

    public void fetch(Message[] messages, FetchProfile profile) throws MessagingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
    }

    private int getCount(Flags.Flag flag) throws MessagingException {
        return this.getCount(flag, true);
    }

    private int getCount(Flags.Flag flag, boolean value) throws MessagingException {
        if (this.isOpen()) {
            Message[] messages = this.getMessages();
            int total = 0;
            for (int i = 0; i < messages.length; ++i) {
                if (messages[i].getFlags().contains(flag) != value) continue;
                ++total;
            }
            return total;
        }
        return -1;
    }

    public int getDeletedMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.DELETED);
    }

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract String getFullName();

    public abstract Message getMessage(int var1) throws MessagingException;

    public abstract int getMessageCount() throws MessagingException;

    public Message[] getMessages() throws MessagingException {
        return this.getMessages(1, this.getMessageCount());
    }

    public Message[] getMessages(int from, int to) throws MessagingException {
        if (to == -1 || to < from) {
            throw new IndexOutOfBoundsException("Invalid message range: " + from + " to " + to);
        }
        Message[] result = new Message[to - from + 1];
        for (int i = from; i <= to; ++i) {
            result[i] = this.getMessage(i);
        }
        return result;
    }

    public Message[] getMessages(int[] ids) throws MessagingException {
        Message[] result = new Message[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = this.getMessage(ids[i]);
        }
        return result;
    }

    public int getMode() {
        return this.mode;
    }

    public abstract String getName();

    public int getNewMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.RECENT);
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract Flags getPermanentFlags();

    public abstract char getSeparator() throws MessagingException;

    public Store getStore() {
        return this.store;
    }

    public abstract int getType() throws MessagingException;

    public int getUnreadMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.SEEN, false);
    }

    public URLName getURLName() throws MessagingException {
        return this.store.getURLName();
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract boolean isOpen();

    public boolean isSubscribed() {
        return this._subscribed;
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.list(pattern);
    }

    protected void notifyConnectionListeners(int type) {
        ConnectionEvent event = new ConnectionEvent(this, type);
        Iterator it = this._connectionListeners.iterator();
        while (it.hasNext()) {
            TransportListener listener = (TransportListener)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyFolderListeners(int type) {
        Iterator it = this._folderListeners.iterator();
        FolderEvent event = new FolderEvent(this, this, type);
        while (it.hasNext()) {
            FolderListener listener = (FolderListener)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyFolderRenamedListeners(Folder newFolder) {
        Iterator it = this._folderListeners.iterator();
        FolderEvent event = new FolderEvent(this, this, newFolder, 3);
        while (it.hasNext()) {
            FolderListener listener = (FolderListener)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyMessageAddedListeners(Message[] messages) {
        Iterator it = this._messageChangedListeners.iterator();
        MessageCountEvent event = new MessageCountEvent(this, 1, false, messages);
        while (it.hasNext()) {
            MessageCountEvent listener = (MessageCountEvent)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyMessageChangedListeners(int type, Message message) {
        Iterator it = this._messageChangedListeners.iterator();
        MessageChangedEvent event = new MessageChangedEvent(this, type, message);
        while (it.hasNext()) {
            MessageCountEvent listener = (MessageCountEvent)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyMessageRemovedListeners(boolean removed, Message[] messages) {
        Iterator it = this._messageChangedListeners.iterator();
        MessageCountEvent event = new MessageCountEvent(this, 2, removed, messages);
        while (it.hasNext()) {
            MessageCountEvent listener = (MessageCountEvent)it.next();
            event.dispatch(listener);
        }
    }

    public abstract void open(int var1) throws MessagingException;

    public void removeConnectionListener(ConnectionListener listener) {
        this._connectionListeners.remove(listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this._folderListeners.remove(listener);
    }

    public void removeMessageChangedListener(MessageChangedListener listener) {
        this._messageChangedListeners.remove(listener);
    }

    public void removeMessageCountListener(MessageCountListener listener) {
        this._messageCountListeners.remove(listener);
    }

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.search(term, this.getMessages());
    }

    public Message[] search(SearchTerm term, Message[] messages) throws MessagingException {
        LinkedList<Message> result = new LinkedList<Message>();
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            if (!term.match(message)) continue;
            result.add(message);
        }
        return result.toArray(MESSAGE_ARRAY);
    }

    public void setFlags(int from, int to, Flags flags, boolean value) throws MessagingException {
        this.setFlags(this.getMessages(from, to), flags, value);
    }

    public void setFlags(int[] ids, Flags flags, boolean value) throws MessagingException {
        this.setFlags(this.getMessages(ids), flags, value);
    }

    public void setFlags(Message[] messages, Flags flags, boolean value) throws MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            message.setFlags(flags, value);
        }
    }

    public void setSubscribed(boolean subscribed) throws MessagingException {
        this._subscribed = subscribed;
    }

    public String toString() {
        String name = this.getFullName();
        if (name == null) {
            return super.toString();
        }
        return name;
    }
}

