/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.services.sys.http;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.httpserver.httpservice.BaseHttpService;
import com.simba.common.common.httpserver.httpservice.IHttpRequest;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.wcsclient.actions.ServiceMenu;
import com.simba.server.wcsclient.common.ConstManager;
import com.simba.server.wcsclient.models.DaoAction;
import com.simba.server.wcsclient.models.DaoLoginLog;
import com.simba.server.wcsclient.models.DaoRole;
import com.simba.server.wcsclient.models.DaoUser;
import com.simba.server.wcsclient.services.utils.ResponseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class LoginHttpService
extends BaseHttpService {
    public static final String NAME = "login";

    @IHttpRequest(Url="login_in", Method="POST")
    public void LoginIn(Channel channel, Map<String, Object> content, HttpRequest request) {
        Map<String, Object> responseParam;
        try {
            String workerNumber = this.getStringByParam(content, "workerNumber");
            String password = this.getStringByParam(content, "password");
            String ip = this.getStringByParam(content, "ip");
            String browser = this.getStringByParam(content, "browser");
            if (StringUtil.isNull(workerNumber).booleanValue() || StringUtil.isNull(password).booleanValue()) {
                Map<String, Object> responseParam2 = ResponseUtil.CreateResponseMap(false, "\u7528\u6237\u540d\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
                this.renderJson(channel, responseParam2, request);
                return;
            }
            HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
            maps.put("user_id", new ParamBean(workerNumber));
            maps.put("user_password", new ParamBean(password));
            int rowCount = DaoUser.GetInstance().GetCountByCondition(maps, null, null, null);
            if (rowCount < 0) {
                Map<String, Object> responseParam3 = ResponseUtil.CreateResponseMap(false, "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!");
                this.renderJson(channel, responseParam3, request);
                return;
            }
            if (rowCount == 0) {
                Map<String, Object> responseParam4 = ResponseUtil.CreateResponseMap(false, "\u5de5\u53f7\u6216\u5bc6\u7801\u9519\u8bef!");
                this.renderJson(channel, responseParam4, request);
                return;
            }
            Map[] table = DaoUser.GetInstance().GetDataByPage(0, 1, 1, maps, null, null, null, null, false).getPageData();
            if (table[0].get("user_status").toString().equals(ConstManager.CONST_VALUE_USER_STATUS_INVALID)) {
                Map<String, Object> responseParam5 = ResponseUtil.CreateResponseMap(false, "\u5de5\u53f7\u672a\u6fc0\u6d3b!");
                this.renderJson(channel, responseParam5, request);
                return;
            }
            maps.clear();
            maps.put("last_login_time", new ParamBean(StringUtil.getDateNow(), 2));
            DaoUser.GetInstance().UpdateDataById(maps, table[0].get(DaoUser.COLUMN_ID).toString());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("userId", table[0].get(DaoUser.COLUMN_ID));
            SortedMap[] roleList = DaoRole.GetInstance().listSysRoleByUserId(param).getRows();
            if (roleList == null || roleList.length == 0) {
                Map<String, Object> responseParam6 = ResponseUtil.CreateResponseMap(false, "\u7528\u6237\u5c1a\u672a\u5206\u914d\u89d2\u8272!");
                this.renderJson(channel, responseParam6, request);
                return;
            }
            ArrayList<String> roleIdList = new ArrayList<String>();
            for (SortedMap sysRole : roleList) {
                roleIdList.add(sysRole.get(DaoRole.COLUMN_ID).toString());
            }
            param = new HashMap();
            param.put("roleIdList", roleIdList);
            List<Map<String, Object>> menuList = ServiceMenu.GetInstance().listSysRoleMenu(param);
            SortedMap[] actionCodeList = DaoAction.GetInstance().listSysRoleActionCode(param).getRows();
            HashMap<String, ParamBean> loginLog = new HashMap<String, ParamBean>();
            loginLog.put("user_id", new ParamBean(table[0].get(DaoUser.COLUMN_ID)));
            loginLog.put("username", new ParamBean(table[0].get("user_id")));
            loginLog.put("login_ip", new ParamBean(ip));
            loginLog.put("browser_info", new ParamBean(browser));
            loginLog.put("login_time", new ParamBean(StringUtil.getDateNow(), 2));
            DaoLoginLog.GetInstance().AddNewDataInfo(loginLog);
            responseParam = ResponseUtil.CreateResponseMap(true, "\u767b\u9646\u6210\u529f!");
            responseParam.put("userInfo", table);
            responseParam.put("roleList", roleList);
            responseParam.put("menuList", menuList);
            responseParam.put("actionCodeList", actionCodeList);
        }
        catch (Exception e) {
            responseParam = ResponseUtil.CreateResponseMap(false, "\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        this.renderJson(channel, responseParam, request);
    }

    @IHttpRequest(Url="login_out")
    public void LoginOut(Channel channel, Map<String, Object> content, HttpRequest request) {
    }
}

