/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.models;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;

public class DaoRole
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tb_sys_role";
    public static final String COLUMN_ROLE_NAME = "role_name";
    public static final String COLUMN_ROLE_MEMO = "role_memo";
    public static final String COLUMN_CREATE_TIME = "create_time";
    public static final String COLUMN_CREATE = "creator";
    public static final String COLUMN_MODIFY_TIME = "modify_time";
    public static final String COLUMN_MODIFIER = "modifier";
    private static DaoRole instance;

    public static DaoRole GetInstance() {
        if (instance == null) {
            instance = new DaoRole();
        }
        return instance;
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[]{COLUMN_ROLE_NAME, COLUMN_ROLE_MEMO};
    }

    @Override
    public String[] GetOrderColumn() {
        return null;
    }

    @Override
    public int CreateTable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{COLUMN_ID, "int", "11", "NOT NULL"});
        list.add(new String[]{COLUMN_ROLE_NAME, "varchar", "100", "NOT NULL"});
        list.add(new String[]{COLUMN_ROLE_MEMO, "varchar", "500", "NOT NULL"});
        list.add(new String[]{COLUMN_CREATE_TIME, "datetime", "", "NOT NULL"});
        list.add(new String[]{COLUMN_CREATE, "varchar", "100", "NOT NULL"});
        list.add(new String[]{COLUMN_MODIFY_TIME, "datetime", "", "NOT NULL"});
        list.add(new String[]{COLUMN_MODIFIER, "varchar", "100", "NOT NULL"});
        return this.dbHelper.CreateTable(DATABASE_TABLE_NAME, list, null);
    }

    @Override
    public void CreateDefaultData() {
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put(COLUMN_ID, new ParamBean(1));
        maps.put(COLUMN_ROLE_NAME, new ParamBean("\u8d85\u7ea7\u7ba1\u7406\u5458"));
        maps.put(COLUMN_ROLE_MEMO, new ParamBean("\u8d85\u7ea7\u7ba1\u7406\u5458"));
        maps.put(COLUMN_CREATE_TIME, new ParamBean(StringUtil.getDateNow(), 2));
        maps.put(COLUMN_CREATE, new ParamBean("auto"));
        maps.put(COLUMN_MODIFY_TIME, new ParamBean(StringUtil.getDateNow(), 2));
        maps.put(COLUMN_MODIFIER, new ParamBean("auto"));
        this.dbHelper.AddData(DATABASE_TABLE_NAME, maps, true);
    }

    @Override
    public int AddNewDataInfo(Map<String, ParamBean> maps) {
        return this.dbHelper.AddData(DATABASE_TABLE_NAME, maps, false);
    }

    public Result listSysUserRole(Map<String, ParamBean> param) {
        if (param.get("userId") != null) {
            String sql = "SELECT T1.id as role_id, T1.role_name, COUNT(T2.id) as user_count FROM tb_sys_role T1 LEFT JOIN tb_sys_role_user T2 ON T1.id = T2.role_id AND T2.user_id = " + param.get("userId").getValue() + " GROUP BY T1.id ,T1.role_name";
            return this.dbHelper.QueryBySql(sql);
        }
        return null;
    }

    public Result listSysRoleByUserId(Map<String, Object> param) {
        if (param.get("userId") != null) {
            String sql = "SELECT T1.id, T1.role_name, T1.role_memo, T1.create_time, T1.creator, T1.modify_time, T1.modifier FROM tb_sys_role T1 WHERE EXISTS (SELECT 1 FROM tb_sys_role_user T2 WHERE T1.id = T2.role_id AND T2.user_id = " + param.get("userId") + ")";
            return this.dbHelper.QueryBySql(sql);
        }
        return null;
    }
}

