/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.models;

import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;

public class DaoAction
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tb_sys_action";
    public static final String COLUMN_ACTION_CODE = "action_code";
    public static final String COLUMN_ACTION_NAME = "action_name";
    public static final String COLUMN_ACTION_URL = "action_url";
    public static final String COLUMN_SYSTEM_MODULE = "system_module";
    public static final String COLUMN_DESCRIPTION = "description";
    private static DaoAction instance;

    public static DaoAction GetInstance() {
        if (instance == null) {
            instance = new DaoAction();
        }
        return instance;
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return null;
    }

    @Override
    public String[] GetOrderColumn() {
        return null;
    }

    @Override
    public int CreateTable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{COLUMN_ID, "int", "11", "NOT NULL"});
        list.add(new String[]{COLUMN_ACTION_CODE, "varchar", "100", "NOT NULL"});
        list.add(new String[]{COLUMN_ACTION_NAME, "varchar", "100", "NOT NULL"});
        list.add(new String[]{COLUMN_ACTION_URL, "varchar", "200", "DEFAULT ''"});
        list.add(new String[]{COLUMN_SYSTEM_MODULE, "varchar", "100", "NOT NULL"});
        list.add(new String[]{COLUMN_DESCRIPTION, "varchar", "500", "DEFAULT ''"});
        return this.dbHelper.CreateTable(DATABASE_TABLE_NAME, list, new String[]{COLUMN_ACTION_CODE});
    }

    public Result listSysRoleActionCode(Map<String, Object> param) {
        String sql = "SELECT T1.action_code FROM tb_sys_action T1 WHERE EXISTS (SELECT 1 FROM tb_sys_role_action T2 WHERE T1.action_code = T2.action_code";
        if (param.get("roleIdList") != null) {
            List roleIdList = (List)param.get("roleIdList");
            sql = sql + " AND (";
            for (String roleId : roleIdList) {
                sql = sql + "T2.role_id = " + roleId + " OR ";
            }
            if (roleIdList.size() > 0) {
                sql = sql.substring(0, sql.length() - 3);
            }
            sql = sql + ")";
        }
        sql = sql + ")";
        return this.dbHelper.QueryBySql(sql);
    }

    public Result listSysRoleAction(Map<String, Object> param) {
        String sql = "SELECT T1.id,T1.action_code,T1.action_name,T1.action_url,T1.system_module,T1.description FROM tb_sys_action T1 WHERE EXISTS (SELECT 1 FROM tb_sys_role_action T2 WHERE T1.action_code = T2.action_code";
        if (param.get("roleIdList") != null) {
            List roleIdList = (List)param.get("roleIdList");
            sql = sql + " AND (";
            for (String roleId : roleIdList) {
                sql = sql + "T2.role_id = " + roleId + " OR ";
            }
            if (roleIdList.size() > 0) {
                sql = sql.substring(0, sql.length() - 3);
            }
            sql = sql + ")";
        }
        sql = sql + ")";
        return this.dbHelper.QueryBySql(sql);
    }

    public Result listSysActionRoleInfo(Map<String, Object> param) {
        if (param.get("roleId") != null) {
            String sql = "SELECT T1.id, T1.action_code, T1.action_name, T1.system_module, COUNT(T2.role_id) AS role_count FROM tb_sys_action T1 LEFT JOIN tb_sys_role_action T2 ON T1.action_code = T2.action_code AND T2.role_id = " + param.get("roleId") + " GROUP BY T1.id,T1.action_code,T1.action_name,T1.system_module";
            return this.dbHelper.QueryBySql(sql);
        }
        return null;
    }
}

