/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.common;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.monitor.constants.MonitorActionConstants;
import com.simba.server.wcsclient.common.ConstManager;
import com.simba.server.wcsclient.models.DaoAction;
import com.simba.server.wcsclient.models.DaoConst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public abstract class BasePermissionManager {
    private Map<String, String> modules = new HashMap<String, String>();
    private List<String> actionList;
    private List<Map<String, ParamBean>> actionMap = new ArrayList<Map<String, ParamBean>>();
    private List<Map<String, ParamBean>> moduleMap = new ArrayList<Map<String, ParamBean>>();

    public void init() {
        this.initModule();
        this.initAction();
    }

    private String createCode() {
        String code = "";
        boolean flag = true;
        while (flag) {
            code = "1001" + StringUtil.formatZero(new Random().nextInt(100) + "", 3);
            if (this.modules.containsValue(code)) continue;
            flag = false;
        }
        return code;
    }

    protected void createAction(String code, String name, String module) {
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("action_code", new ParamBean(module + code));
        maps.put("action_name", new ParamBean(name));
        maps.put("action_url", new ParamBean(""));
        maps.put("system_module", new ParamBean(module));
        maps.put("description", new ParamBean(""));
        this.actionMap.add(maps);
    }

    protected void createModule(String moduleCode, String moduleName) {
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put("const_code", new ParamBean(moduleCode));
        maps.put("type_code", new ParamBean("1001"));
        maps.put("type_desc", new ParamBean("\u7cfb\u7edf\u6a21\u5757"));
        maps.put("const_name", new ParamBean(moduleName));
        maps.put("show_order", new ParamBean("1"));
        maps.put("const_memo", new ParamBean(moduleName));
        maps.put("is_valid", new ParamBean(ConstManager.CONST_VALUE_STATUS_VALID));
        this.moduleMap.add(maps);
    }

    private void syncAction() {
        DaoAction.GetInstance().BatchAddData(this.actionMap);
        this.actionMap.clear();
    }

    private void syncModule() {
        DaoConst.GetInstance().BatchAddData(this.moduleMap);
        this.moduleMap.clear();
    }

    public void addAction(String name, Map<String, String> param) {
        if (param.size() > 0) {
            for (String key : param.keySet()) {
                this.createAction(key, param.get(key), name);
            }
        }
    }

    private void initModule() {
        this.createModule("UserInfo", "\u4e2a\u4eba\u4fe1\u606f");
        this.createModule("UserPassword", "\u4fee\u6539\u5bc6\u7801");
        this.createModule("MessageUser", "\u7528\u6237\u4fe1\u606f");
        this.createModules();
        this.syncModule();
    }

    private void initAction() {
        this.createUserAction();
        this.createMonitorCenterAction();
        this.createOperaActionByTable("MessageUser");
        this.createOperaActionByTable("Users");
        this.createOperaActionByTable("Roles");
        this.createActions();
        this.syncAction();
    }

    protected void createOperaActionByTable(String moduleName) {
        this.createAction("A101", "\u67e5\u8be2", moduleName);
        this.createAction("A102", "\u6dfb\u52a0", moduleName);
        this.createAction("A103", "\u6e05\u7a7a", moduleName);
        this.createAction("A104", "\u5220\u9664", moduleName);
        this.createAction("A105", "\u4fee\u6539", moduleName);
        this.createAction("A106", "\u5bfc\u5165", moduleName);
        this.createAction("A107", "\u5bfc\u51fa", moduleName);
    }

    private void createUserAction() {
        this.createAction("A301", "\u8bbe\u7f6e\u83dc\u5355", "Roles");
        this.createAction("A302", "\u8bbe\u7f6e\u529f\u80fd", "Roles");
        this.createAction("A303", "\u8bbe\u7f6e\u6d88\u606f", "Roles");
        this.createAction("A401", "\u8bbe\u7f6e\u89d2\u8272", "Users");
        this.createAction("A201", "\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f", "UserInfo");
        this.createAction("A202", "\u4fee\u6539\u767b\u5f55\u5bc6\u7801", "UserPassword");
        this.createAction("A501", "\u53d1\u9001\u6d88\u606f", "NetWork");
    }

    private void createMonitorCenterAction() {
        this.createAction(MonitorActionConstants.ACTION_MONITOR_SORT_PORT_CONF, "\u83b7\u53d6\u5206\u62e3\u53e3\u914d\u7f6e", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_ERROR, "\u6545\u969c", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_START, "\u542f\u52a8", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_STOP, "\u505c\u6b62", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_EMERGENCY_STOP, "\u6025\u505c", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_SLOT_SYNC, "\u683c\u53e3\u540c\u6b65", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_SLOT_RESET, "\u683c\u53e3\u590d\u4f4d", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_CAR_SYNC, "\u5c0f\u8f66\u540c\u6b65", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_CAR_RESET, "\u5c0f\u8f66\u590d\u4f4d", "Machine");
        this.createAction(MonitorActionConstants.ACTION_MONITOR_SORT_SPEED, "\u4fee\u6539\u901f\u5ea6", "Machine");
    }

    public abstract void createModules();

    public abstract void createActions();
}

