/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.actions;

import com.simba.common.common.database.bean.ParamBean;
import com.simba.server.wcsclient.models.DaoMessageType;
import com.simba.server.wcsclient.models.DaoRoleMessageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;

public class ServiceMessage {
    private static ServiceMessage instance;

    public static ServiceMessage GetInstance() {
        if (instance == null) {
            instance = new ServiceMessage();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSysRoleMessage(String roleId, List<Map<String, ParamBean>> roleMessageList) {
        ServiceMessage serviceMessage = this;
        synchronized (serviceMessage) {
            HashMap<String, ParamBean> param = new HashMap<String, ParamBean>();
            param.put("roleId", new ParamBean(roleId));
            DaoRoleMessageType.GetInstance().deleteSysRoleMenuByRoleId(param);
            if (roleMessageList != null && roleMessageList.size() > 0) {
                DaoRoleMessageType.GetInstance().BatchAddData(roleMessageList);
            }
        }
    }

    public List<Map<String, Object>> listSysRoleMessage(Map<String, ParamBean> param) {
        Result result = DaoMessageType.GetInstance().listSysRoleMessage(param);
        if (result == null) {
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String, Object>> sysMessageList = Arrays.asList(result.getRows());
        if (sysMessageList.size() > 0) {
            ArrayList<Map<String, Object>> newMessageList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> startMessage = new HashMap<String, Object>();
            startMessage.put(DaoMessageType.COLUMN_ID, 0L);
            this.initMessageList(startMessage, sysMessageList, newMessageList);
            return newMessageList;
        }
        return sysMessageList;
    }

    private void initMessageList(Map<String, Object> startMessage, List<Map<String, Object>> oldMessageList, List<Map<String, Object>> newMessageList) {
        String startId = startMessage.get(DaoMessageType.COLUMN_ID).toString();
        ArrayList<Map<String, Object>> tmpMessageList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> message : oldMessageList) {
            if (message.get("parent_id") == null || !message.get("parent_id").equals(startId)) continue;
            tmpMessageList.add(message);
        }
        if (!startMessage.get(DaoMessageType.COLUMN_ID).equals("0")) {
            newMessageList.add(startMessage);
        }
        if (tmpMessageList.size() > 0) {
            for (Map<String, Object> tmpMessage : tmpMessageList) {
                this.initMessageList(tmpMessage, oldMessageList, newMessageList);
            }
        }
    }

    public List<Map<String, Object>> listSysMessageRoleTreeInfo(Map<String, ParamBean> param) {
        Result result = DaoMessageType.GetInstance().listSysMessageRoleInfo(param);
        if (result == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> messageTreeList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> sysMessageList = Arrays.asList(result.getRows());
        if (sysMessageList.size() > 0) {
            HashMap<String, Object> message = new HashMap<String, Object>();
            message.put("id", 0L);
            message.put("text", "\u6d88\u606f\u7c7b\u578b");
            message.put("iconCls", "icon-computer");
            this.initMessageList(message, sysMessageList);
            messageTreeList.add(message);
        }
        return messageTreeList;
    }

    private void initMessageList(Map<String, Object> startMessage, List<Map<String, Object>> messageList) {
        String startId = startMessage.get("id").toString();
        ArrayList<Map<String, Object>> tmpMessageList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> message : messageList) {
            String parentMessageId = message.get("parent_id").toString();
            if (parentMessageId == null || !parentMessageId.equals(startId)) continue;
            tmpMessageList.add(message);
        }
        if (tmpMessageList.size() > 0) {
            for (Map<String, Object> tmpMessage : tmpMessageList) {
                this.initMessageList(tmpMessage, messageList);
            }
            startMessage.put("children", this.getChildrenList(tmpMessageList));
        }
    }

    private List<Map<String, Object>> getChildrenList(List<Map<String, Object>> messageList) {
        ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> message : messageList) {
            HashMap<String, Object> child = new HashMap<String, Object>();
            child.put("id", message.get("id"));
            child.put("text", message.get("type_name"));
            long roleCount = (Long)message.get("role_count");
            if (!(roleCount <= 0L || message.containsKey("children") && message.get("children") != null)) {
                child.put("checked", true);
            }
            child.put("children", message.getOrDefault("children", null));
            childrenList.add(child);
        }
        return childrenList;
    }
}

