/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.tables.daos.Report;

import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.DaoBaseClass;
import com.simba.common.common.database.dao.IDaoBaseClass;
import java.util.Map;

public class DaoReadRate
extends DaoBaseClass
implements IDaoBaseClass {
    public static final String DATABASE_TABLE_NAME = "tt_packet_off_info";
    public static final String COLUMN_RECORD_DATE = "packetOfftime";
    public static final String COLUMN_READ_TOTAL = "total";
    public static final String COLUMN_READ_SUCESS_TOTAL = "success";
    public static final String COLUMN_READ_RATE = "successrate";
    public static final String COLUMN_UNREAD_RATE = "failrate";
    public static final String COLUMN_MULTI = "multicode";
    public static final String COLUMN_MULTI_RATE = "multirate";
    public static final String COLUMN_NOREAD = "noread";
    public static final String COLUMN_NOREAD_RATE = "noreadrate";
    public static final String COLUMN_INFEED = "platId";
    public static final String COLUMN_OBR = "obrNumber";
    private String m_strGroup = null;
    private static DaoReadRate instance;

    public static DaoReadRate GetInstance() {
        if (instance == null) {
            instance = new DaoReadRate();
        }
        return instance;
    }

    @Override
    public DbPageData GetDataByPage(int pageSize, int currentPage, int count, Map<String, ParamBean> maps, String keywords, String[] ignoreKeys, String group, String having, boolean isOrderDesc) {
        String strFileds = "obrNo,count(barcode) as total,sum(case when errorCodePLC != 9 then 1 else 0 end) as success,sum(case when errorCodePLC = 9 then 1 else 0 end) as noread,sum(case when errorCodePLC = 3 then 1 else 0 end) as multicode ";
        this.m_strGroup = "obrNo";
        DbPageData tmpage = this.dbHelper.GetDataPage(DATABASE_TABLE_NAME, pageSize, currentPage, count, strFileds, maps, this.GetKeywordsColumn(), keywords, null, false, null, this.m_strGroup, null, ignoreKeys);
        return this.getPagedata(tmpage);
    }

    @Override
    public int GetCountByCondition(Map<String, ParamBean> maps, String keywords, String condition, String[] ignoreKeys) {
        String strFileds = "obrNo,count(barcode) as total,sum(case when errorCodePLC != 3 then 1 else 0 end) as success ";
        this.m_strGroup = "obrNo";
        DbPageData tmpage = this.dbHelper.GetDataPage(DATABASE_TABLE_NAME, 0, 1, 1, strFileds, maps, this.GetKeywordsColumn(), keywords, null, false, null, this.m_strGroup, null, ignoreKeys);
        Map[] dt = tmpage.getPageData();
        if (dt == null) {
            return 0;
        }
        return dt.length;
    }

    private DbPageData getPagedata(DbPageData dbPageData) {
        DbPageData tmpage = dbPageData;
        if (tmpage == null) {
            return tmpage;
        }
        Map[] dt = dbPageData.getPageData();
        if (dt == null) {
            return tmpage;
        }
        int rowsCount = dt.length;
        try {
            for (int j = 0; j < rowsCount; ++j) {
                String strSum = dt[j].get(COLUMN_READ_TOTAL).toString();
                String strSuccess = dt[j].get(COLUMN_READ_SUCESS_TOTAL).toString();
                String strNoReadCount = dt[j].get(COLUMN_NOREAD).toString();
                String strMultiCount = dt[j].get(COLUMN_MULTI).toString();
                int noReadCount = Integer.parseInt(strNoReadCount);
                int nsum = Integer.parseInt(strSum);
                int nsuccess = Integer.parseInt(strSuccess);
                int nMulti = Integer.parseInt(strMultiCount);
                double dsuccessrate = 0.0;
                double dnoreadrate = 0.0;
                double dmultirate = 0.0;
                if (nsum > 0) {
                    dsuccessrate = Double.parseDouble(nsuccess + "") / Double.parseDouble(nsum + "");
                }
                if (nsum > 0) {
                    dnoreadrate = Double.parseDouble(noReadCount + "") / Double.parseDouble(nsum + "");
                }
                if (nsum > 0) {
                    dmultirate = Double.parseDouble(nMulti + "") / Double.parseDouble(nsum + "");
                }
                dt[j].put(COLUMN_READ_RATE, String.format("%.2f", dsuccessrate * 100.0) + "%");
                dt[j].put(COLUMN_NOREAD_RATE, String.format("%.2f", dnoreadrate * 100.0) + "%");
                dt[j].put(COLUMN_MULTI_RATE, String.format("%.2f", dmultirate * 100.0) + "%");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmpage.setPageData(dt);
        return tmpage;
    }

    @Override
    public String GetDataBaseName() {
        return DATABASE_TABLE_NAME;
    }

    @Override
    public String[] GetKeywordsColumn() {
        return new String[0];
    }

    @Override
    public String[] GetOrderColumn() {
        return new String[0];
    }
}

