/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.monitor.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simba.common.common.utils.JsonContentUtil;
import com.simba.server.monitor.managers.MonitorManager;
import com.simba.server.monitor.managers.MonitorMessage;
import java.util.HashMap;

public class MonitorOperator {
    private Gson gson = new GsonBuilder().serializeNulls().create();

    private MonitorOperator() {
    }

    public static MonitorOperator getInstance() {
        return MonitorOperatorHolder.INSTANCE;
    }

    public void updateMonitorStatus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceName", "MonitorInfo");
        map.put("CurrentCar", MonitorManager.getInstance().getCurrentCar());
        map.put("CurrentSpeed", MonitorManager.getInstance().getCurrentSpeed());
        map.put("Frequency", MonitorManager.getInstance().getFrequency());
        map.put("Cars", MonitorManager.getInstance().getCars());
        map.put("Slots", MonitorManager.getInstance().getSlots());
        map.put("Supplys", MonitorManager.getInstance().getSupplys());
        map.put("Stops", MonitorManager.getInstance().getStops());
        map.put("Machines", MonitorManager.getInstance().getMachines());
        String monitorStatus = this.gson.toJson(map);
        JsonContentUtil.getInstance().SendClientMessage(monitorStatus);
    }

    public void Refresh() {
        byte[] result = MonitorMessage.getInstance().CreateSlotReplayMessage(1);
        MonitorMessage.getInstance().SendMessage(result);
        result = MonitorMessage.getInstance().CreateCarReplayMessage(1);
        MonitorMessage.getInstance().SendMessage(result);
    }

    public void SendMessage(int value, String key) {
        byte[] result = null;
        switch (key) {
            case "system": {
                result = MonitorMessage.getInstance().CreateSystemControlReplayMessage(value);
                break;
            }
            case "speed": {
                result = MonitorMessage.getInstance().CreateSpeedReplayMessage(value);
                break;
            }
            case "syncSlot": {
                result = MonitorMessage.getInstance().CreateSlotReplayMessage(value);
                break;
            }
            case "syncCar": {
                result = MonitorMessage.getInstance().CreateCarReplayMessage(value);
                break;
            }
            default: {
                return;
            }
        }
        MonitorMessage.getInstance().SendMessage(result);
    }

    public void updateExceptionStop(int stopReason, int speed) {
        if (stopReason == 0) {
            // empty if block
        }
        if (stopReason == 1) {
            // empty if block
        }
        if (stopReason == 2) {
            // empty if block
        }
        if (stopReason == 3) {
            // empty if block
        }
        if (stopReason == 4) {
            // empty if block
        }
        if (stopReason == 5) {
            // empty if block
        }
    }

    private static class MonitorOperatorHolder {
        private static final MonitorOperator INSTANCE = new MonitorOperator();

        private MonitorOperatorHolder() {
        }
    }
}

