/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.monitor.jsons.items;

import com.simba.common.common.jsonserver.jsonservice.JsonService;
import com.simba.common.common.log.LogManager;
import com.simba.server.monitor.managers.MonitorOperator;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitorService
implements JsonService {
    public static final String NAME = "Monitor";
    private static final Logger logger = Logger.getLogger(MonitorService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            String command = request.getString("Command");
            int status = request.getInt("Status");
            LogManager.LogDebug(logger, "Monitor Json Service request name : [" + name + "]");
            switch (command) {
                case "system": {
                    MonitorOperator.getInstance().SendMessage(status, "system");
                    break;
                }
                case "speed": {
                    MonitorOperator.getInstance().SendMessage(status, "speed");
                    break;
                }
                case "syncSlot": {
                    MonitorOperator.getInstance().SendMessage(status, "syncSlot");
                    break;
                }
                case "syncCar": {
                    MonitorOperator.getInstance().SendMessage(status, "syncCar");
                    break;
                }
            }
        }
        catch (JSONException ex) {
            LogManager.LogError(logger, "Monitor Json Service Error : exception info : " + ex.getMessage());
        }
    }
}

