/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.monitor.decoders.items;

import com.simba.common.business.FrameUtils;
import com.simba.common.common.decoder.Decoder;
import com.simba.server.monitor.managers.MonitorManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class MachineStatus
implements Decoder {
    private static final Logger logger = Logger.getLogger(MachineStatus.class);
    public static final String NAME = "MachineStatus";
    private static final int MACHINE_COUNT_POSITION = 3;
    private static final int MACHINE_STATUS_POSITION = 4;

    @Override
    public void doDecode(Channel connection, Object message) {
        byte[] content = (byte[])message;
        int machineCount = content[3];
        double machineFrequency = FrameUtils.getInstance().getUnsignedShortBigEndian(4 + machineCount, content);
        double currentSpeed = FrameUtils.getInstance().getUnsignedShortBigEndian(4 + machineCount + 2, content);
        block5: for (int i = 0; i < machineCount; ++i) {
            byte machineStatus = content[4 + i];
            switch (machineStatus) {
                case 0: {
                    MonitorManager.getInstance().updateMachineStatus(i, "\u5f85\u673a\u4e2d");
                    continue block5;
                }
                case 1: {
                    MonitorManager.getInstance().updateMachineStatus(i, "\u8fd0\u8f6c\u4e2d");
                    continue block5;
                }
                case 2: {
                    MonitorManager.getInstance().updateMachineStatus(i, "\u6545\u969c\u4e2d");
                }
            }
        }
        MonitorManager.getInstance().setCurrentSpeed(currentSpeed / 1000.0);
        MonitorManager.getInstance().setFrequency(machineFrequency / 10.0);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

