/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.common.framedecoder.CommonFrameDecoderManager;
import com.simba.common.httpservice.CommonHttpServiceManager;
import com.simba.common.jsonservice.CommonJsonServiceManager;
import com.simba.server.BaseServerManager;
import com.simba.server.GlobalParam;
import com.simba.server.ServerParam;
import com.simba.server.decoders.FrameDecoderManager;
import com.simba.server.https.HttpServiceManager;
import com.simba.server.jsons.JsonServiceManager;
import com.simba.server.monitor.jsons.JsonClientManager;
import com.simba.server.monitor.managers.MonitorUpdateTask;
import com.simba.server.tables.DatabaseManager;
import com.simba.server.tables.MenuManager;
import com.simba.server.tables.PermissionManager;

public class ServerManager
extends BaseServerManager {
    private static ServerManager instance = new ServerManager();

    public static ServerManager getInstance() {
        return instance;
    }

    private void initParam() {
        GlobalParam.databases = DatabaseManager.GetInstance();
        GlobalParam.menus = MenuManager.getInstance();
        GlobalParam.permissions = PermissionManager.GetInstance();
    }

    private void initDatabase() {
        GlobalParam.databases.init();
    }

    private void initMenu() {
        GlobalParam.menus.checkAndInitMenu();
    }

    private void initPermission() {
        GlobalParam.permissions.init();
    }

    private void initJsonClient() {
        JsonClientManager.getInstance().Init();
    }

    private void startSingleThreadTasks() {
        new MonitorUpdateTask().start();
    }

    @Override
    public CommonFrameDecoderManager getFrameDecoderManager() {
        return FrameDecoderManager.getInstance();
    }

    @Override
    public CommonHttpServiceManager getHttpServiceManager() {
        return HttpServiceManager.getInstance();
    }

    @Override
    public CommonJsonServiceManager getJsonServiceManager() {
        return JsonServiceManager.getInstance();
    }

    @Override
    public void initServers() {
        this.initParam();
        this.initMenu();
        this.initPermission();
        this.initDatabase();
        this.initJsonClient();
        this.startSingleThreadTasks();
        ServerParam.printStartedInfo();
    }

    @Override
    public String getCurrentVersion() {
        return "V3.1.14.180706_beta";
    }
}

