/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.dataclient;

import com.simba.common.common.frameclient.IClient;
import com.simba.common.common.frameclient.IClientManager;
import com.simba.common.dataclient.BootstrapManager;
import com.simba.common.dataclient.DataClientNetTask;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataClientManager
implements IClientManager {
    private final DataClientNetTask dataClientNetTask = new DataClientNetTask();
    private Map<String, IClient> clients = new HashMap<String, IClient>();
    private static final Logger logger = Logger.getLogger(DataClientManager.class);

    public static DataClientManager getInstance() {
        return DataClientManagerHolder.INSTANCE;
    }

    private DataClientManager() {
    }

    public DataClientNetTask getDataClientNetTask() {
        return this.dataClientNetTask;
    }

    private void startClientNetThread() {
        this.getDataClientNetTask().start();
    }

    @Override
    public void addClient(String key, IClient client) {
        if (this.clients.containsKey(key)) {
            return;
        }
        this.clients.put(key, client);
    }

    @Override
    public void checkClientStatus() {
    }

    @Override
    public IClient getClient(String key) {
        if (this.clients.containsKey(key)) {
            return this.clients.get(key);
        }
        return null;
    }

    @Override
    public int getClientCount() {
        return this.clients.size();
    }

    @Override
    public Map<String, IClient> getClientList() {
        return this.clients;
    }

    @Override
    public void init(String configFile) {
        BootstrapManager.getInstance().init();
        this.startClientNetThread();
    }

    @Override
    public void removeClient(String key) {
        if (this.clients.containsKey(key)) {
            this.clients.get(key).disconnect();
            this.clients.remove(key);
        }
    }

    public void ShutDown() {
        for (IClient client : this.clients.values()) {
            if (!client.isConnected().booleanValue()) continue;
            client.disconnect();
        }
        this.clients.clear();
    }

    private static class DataClientManagerHolder {
        private static final DataClientManager INSTANCE = new DataClientManager();

        private DataClientManagerHolder() {
        }
    }
}

