/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.utils;

import com.simba.common.common.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtil {
    public static String templateAnalysis(String template, Map<String, Object> maps) {
        try {
            List<String> list = TemplateUtil.getAllTemplateRule(template);
            for (String labelName : list) {
                String value;
                String paramsName;
                if (labelName.equals("foreach")) {
                    if (!template.matches("(.*?)\\{" + labelName + " .*?}(.*?)") || !template.matches("(.*?)\\{" + labelName + "}(.*?)") || !(paramsName = TemplateUtil.getTemplateRule(template, labelName)).contains(":")) continue;
                    String[] params = paramsName.split(":");
                    String[][] data = (String[][])maps.get(params[1]);
                    String startStr = "{" + labelName + " " + paramsName + "}";
                    String endStr = "{" + labelName + "}";
                    String forContent = template.substring(template.indexOf(startStr) + startStr.length(), template.indexOf(endStr));
                    StringBuilder newContent = new StringBuilder();
                    if (data != null && data.length > 0) {
                        for (int i = 0; i < data.length; ++i) {
                            String cache = forContent;
                            for (int j = 0; j < data[i].length; ++j) {
                                cache = cache.replace("{" + params[0] + "[" + j + "]}", data[i][j]);
                            }
                            newContent.append(cache);
                        }
                    } else {
                        newContent.append("\u65e0\u6570\u636e");
                    }
                    template = template.replace(forContent, newContent.toString()).replace(startStr, "").replace(endStr, "");
                    continue;
                }
                if (!labelName.equals("param") || !StringUtil.isNotNull(value = maps.get(paramsName = TemplateUtil.getTemplateRule(template, labelName)).toString()).booleanValue()) continue;
                template = template.replace("{" + labelName + " " + paramsName + "}", value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return template;
        }
        return template;
    }

    private static List<String> getAllTemplateRule(String template) {
        Pattern pattern = Pattern.compile("\\{(.*?) .*?}");
        Matcher matcher = pattern.matcher(template);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group.contains("}")) continue;
            list.add(group);
        }
        return list;
    }

    private static String getTemplateRule(String template, String labelName) {
        Pattern pattern = Pattern.compile("\\{" + labelName + " (.*?)}");
        Matcher matcher = pattern.matcher(template);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }
}

