/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.utils;

import com.simba.common.common.frameclient.IClient;
import com.simba.common.common.jsonserver.JsonChannelManager;
import com.simba.common.common.log.LogManager;
import com.simba.common.dataclient.DataClientManager;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonContentUtil {
    private static final Logger logger = Logger.getLogger(JsonContentUtilHolder.class);

    public static JsonContentUtil getInstance() {
        return JsonContentUtilHolder.INSTANCE;
    }

    private JsonContentUtil() {
    }

    public String GetElement(String elementName, JSONObject jsonObj) {
        String element = "none";
        try {
            Object elementToken = jsonObj.get(elementName);
            if (elementToken != null) {
                element = elementToken.toString();
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception:" + ex.getMessage());
        }
        return element;
    }

    public JSONArray GetArrayElement(String elementName, JSONObject jsonObj) {
        JSONArray element = null;
        try {
            element = new JSONArray(jsonObj.get(elementName).toString());
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception:" + ex.getMessage());
            element = null;
        }
        return element;
    }

    public JSONObject GetObjectElement(String elementName, JSONObject jsonObj) {
        JSONObject element = null;
        try {
            element = new JSONObject(jsonObj.get(elementName).toString());
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception:" + ex.getMessage());
            element = null;
        }
        return element;
    }

    public void SendServerMessage(String message) {
        try {
            byte[] contentBuffer = message.getBytes(StandardCharsets.UTF_8);
            Map<String, IClient> clients = DataClientManager.getInstance().getClientList();
            for (IClient client : clients.values()) {
                client.send(contentBuffer);
            }
        }
        catch (Exception e) {
            LogManager.LogError(logger, "Catch an exception:" + e.getMessage());
        }
    }

    public void SendServerMessage(String key, String message) {
        try {
            byte[] contentBuffer = message.getBytes(StandardCharsets.UTF_8);
            IClient client = DataClientManager.getInstance().getClient(key);
            if (client == null) {
                return;
            }
            client.send(contentBuffer);
        }
        catch (Exception e) {
            LogManager.LogError(logger, "Catch an exception:" + e.getMessage());
        }
    }

    public void SendClientMessage(String message) {
        try {
            Channel[] clients;
            byte[] contentBuffer = message.getBytes(StandardCharsets.UTF_8);
            for (Channel client : clients = JsonChannelManager.getInstance().getChannelList()) {
                client.write(contentBuffer);
            }
        }
        catch (Exception e) {
            LogManager.LogError(logger, "Catch an exception:" + e.getMessage());
        }
    }

    public void SendClientMessage(String key, String message) {
        try {
            byte[] contentBuffer = message.getBytes(StandardCharsets.UTF_8);
            Channel client = JsonChannelManager.getInstance().getChannel(key);
            if (client == null) {
                return;
            }
            client.write(contentBuffer);
        }
        catch (Exception e) {
            LogManager.LogError(logger, "Catch an exception:" + e.getMessage());
        }
    }

    private static class JsonContentUtilHolder {
        private static final JsonContentUtil INSTANCE = new JsonContentUtil();

        private JsonContentUtilHolder() {
        }
    }
}

