/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.utils;

import java.net.InetAddress;

public class InetAddressHelper {
    private static final double A_BEGIN = InetAddressHelper.parseIpToDouble("10.0.0.0");
    private static final double A_END = InetAddressHelper.parseIpToDouble("10.255.255.255");
    private static final double B_BEGIN = InetAddressHelper.parseIpToDouble("172.16.0.0");
    private static final double B_END = InetAddressHelper.parseIpToDouble("172.31.255.255");
    private static final double C_BEGIN = InetAddressHelper.parseIpToDouble("192.168.0.0");
    private static final double C_END = InetAddressHelper.parseIpToDouble("192.168.255.255");
    public static final String LOCAL_ADDRESS = "127.0.0.1";
    public static final String LOCALHOST = "localhost";

    private static double pow(String value, String radix, String power) {
        double v = Double.parseDouble(value);
        double r = Double.parseDouble(radix);
        double p = Double.parseDouble(power);
        double result = Math.pow(r, p) * v;
        return result;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        try {
            double ipNum = InetAddressHelper.parseIpToDouble(ipAddress);
            isInnerIp = ipAddress.equals(LOCAL_ADDRESS) || InetAddressHelper.isInner(ipNum, C_BEGIN, C_END) || InetAddressHelper.isInner(ipNum, A_BEGIN, A_END) || InetAddressHelper.isInner(ipNum, B_BEGIN, B_END);
        }
        catch (Exception ex) {
            isInnerIp = false;
        }
        return isInnerIp;
    }

    private static boolean isInner(double userIp, double begin, double end) {
        return userIp >= begin && userIp <= end;
    }

    public static boolean checkIpSecValidity(String ipStr1, String ipStr2) {
        boolean result = false;
        result = InetAddressHelper.checkIpValidity(ipStr1) && InetAddressHelper.checkIpValidity(ipStr2);
        return result;
    }

    public static double parseIpToDouble(String ipStr) {
        double ipAddress = 0.0;
        String[] temp = ipStr.split("\\.");
        int j = temp.length - 1;
        for (int i = 0; i < temp.length; ++i) {
            ipAddress += InetAddressHelper.pow(temp[i], "256", String.valueOf(j));
            --j;
        }
        return ipAddress;
    }

    public static boolean isIP1SmallerThanIP2(double ip1, double ip2) {
        boolean result = false;
        result = ip1 < ip2;
        return result;
    }

    public static boolean checkIpValidity(String ipStr) {
        boolean valid = false;
        if (ipStr.length() > 0) {
            try {
                String[] temp = ipStr.split("\\.");
                if (temp.length != 4) {
                    throw new Exception();
                }
                InetAddress.getByName(ipStr);
                for (int i = 0; i < temp.length; ++i) {
                    Integer.parseInt(temp[i]);
                }
                valid = true;
            }
            catch (Exception ex) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public static boolean isIpSec(String ipStr) {
        boolean result = false;
        int pos = ipStr.indexOf(124);
        if (pos > 0) {
            double ip2;
            String[] temp = ipStr.split("\\|");
            double ip1 = InetAddressHelper.parseIpToDouble(temp[0]);
            result = Double.compare(ip1, ip2 = InetAddressHelper.parseIpToDouble(temp[1])) != 0;
        }
        return result;
    }
}

