/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.processor;

import com.simba.common.common.ChannelManager;
import com.simba.common.common.RequestHandler;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.processor.BaseProcessor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class JsonProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler serviceHandler;

    public JsonProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.serviceHandler = requestHandler;
        this.channelManager = chManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        this.addChannel(channel);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent cause) throws Exception {
        if (!channel.isConnected()) {
            this.removeChannel(channel);
        }
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        byte[] contentMsg = (byte[])message;
        this.logOnMessageReceived(channel, contentMsg);
        this.serviceHandler.handleRequest(channel, contentMsg);
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    @Override
    protected void addChannel(Channel channel) {
        this.channelManager.addChannel(channel);
        this.logOnChannelConnected(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LogManager.LogDebug(BaseProcessor.LOG, "[JsonProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current json services connection count is : " + String.valueOf(this.channelManager.getChannelCount()));
    }

    @Override
    protected void removeChannel(Channel channel) {
        try {
            String key = String.valueOf(channel.getId());
            this.channelManager.removeChannel(key);
        }
        catch (Exception ex) {
            LogManager.LogError(BaseProcessor.LOG, "[JsonProcessor.removeChannel] Remove Json Service Channel Error -- Exception : " + ex.getMessage());
        }
    }
}

