/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.processor;

import com.simba.common.CommonParam;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.processor.MessageProcessor;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public abstract class BaseProcessor
implements MessageProcessor {
    protected static final Logger LOG = Logger.getLogger(BaseProcessor.class);

    protected abstract void addChannel(Channel var1);

    protected void logOnChannelConnected(Channel channel) {
    }

    protected void logOnChannelDisconnected(Channel channel) {
        if (CommonParam.LOG_MODE != 3) {
            LogManager.LogDebug(LOG, "[BaseProcessor.logOnChannelDisconnected] Connection closed [" + channel.getRemoteAddress() + "]");
        }
    }

    protected void logOnChannelIdel(Channel channel, IdleStateEvent e) {
        LogManager.LogError(LOG, "[BaseProcessor.logOnChannelIdel] Connection idle [" + channel.getRemoteAddress() + "]");
    }

    protected void logOnExceptionCaught(Channel channel, Throwable cause) {
        LogManager.LogError(LOG, "[BaseProcessor.logOnExceptionCaught] Connection exception caught [" + channel.getRemoteAddress() + "] -- " + cause);
    }

    protected void logOnIOExceptionCaught(Channel channel, Throwable cause) {
        if (CommonParam.LOG_MODE != 3) {
            LogManager.LogError(LOG, "[BaseProcessor.logOnIOExceptionCaught] Connection exception caught [" + channel.getRemoteAddress() + "] -- " + cause);
        }
    }

    protected void logOnMessageReceived(Channel channel, Object message) {
    }

    protected abstract void removeChannel(Channel var1);
}

