/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameserver;

import com.simba.common.CommonServerParam;
import com.simba.common.business.CommonProtocolDefines;
import com.simba.common.business.SorterParameter;
import com.simba.common.common.RequestHandler;
import com.simba.common.common.decoder.Decoder;
import com.simba.common.common.decoder.DecoderContainer;
import com.simba.common.common.decoder.DefaultDecoderContainer;
import com.simba.common.common.frameserver.FrameChannelManager;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.thread.CommonExecutorFactory;
import com.simba.common.common.thread.CounterThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public abstract class FrameBaseManager
implements RequestHandler {
    public static final byte CONNECT_MESSGAE_END = -18;
    public static final byte CONNECT_MESSGAE_HEAD = -1;
    protected static final Logger logger = Logger.getLogger(FrameBaseManager.class);
    private static int ASYNC_EXECUTOR_POOL_SIZE = 8;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Frame-Decode-Task";
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();
    private Executor asyncDecodeExecutor;
    private BlockingQueue<Runnable> asyncDecodeOperationQueue;

    public void addDecoder(String decoderName, Decoder decoder) {
        this.decoderContainer.addDecoder(decoderName, decoder);
    }

    public Decoder getDecoder(String decoderName) {
        return this.decoderContainer.getDecoder(decoderName);
    }

    public abstract Decoder getDecoderByCommandNum(byte var1);

    @Override
    public void handleRequest(final Channel channel, final Object message) {
        Runnable executeRunnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (!(message instanceof byte[])) {
                            LogManager.LogInfo(logger, "[CommonFrameDecoderManager.handleRequest] Message is not instance of byte[].");
                            FrameChannelManager.getInstance().commitResponse(channel, CommonProtocolDefines.ERROR_MESSAGE, true);
                            return;
                        }
                        byte[] content = (byte[])message;
                        byte firstByte = content[0];
                        byte secondByte = content[1];
                        if (firstByte != 1 || secondByte != 2) {
                            FrameChannelManager.getInstance().commitResponse(channel, content, true);
                            return;
                        }
                        byte command = content[2];
                        Decoder frameDecoder = FrameBaseManager.this.getDecoderByCommandNum(command);
                        if (frameDecoder != null) {
                            frameDecoder.doDecode(channel, message);
                        }
                    }
                    catch (Exception ex) {
                        LogManager.LogError(logger, "[CommonFrameDecoderManager.handleRequest] catch exception : " + ex.getMessage());
                        if (!(ex instanceof InterruptedException)) break block5;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        if (SorterParameter.getInstance().isNewThreadEachRequest().booleanValue()) {
            this.executeInNewThread(executeRunnable);
        } else {
            this.executeInThreadPool(executeRunnable);
        }
    }

    public void init() {
        this.initAsyncTaskExcutor();
        this.initDecoderContainer();
    }

    public abstract void initDecoderContainer();

    public void postInitProcess() {
        String requestMode = "Request In New Thread";
        if (!SorterParameter.getInstance().isNewThreadEachRequest().booleanValue()) {
            requestMode = "Request In Thread Pool";
        }
        LogManager.LogDebug(logger, "[CommonFrameDecoderManager.postInitProcess] Initialize successfully, Pool size:[" + ASYNC_EXECUTOR_POOL_SIZE + "] reqeust mode:[" + requestMode + "]");
    }

    private void executeInNewThread(Runnable executeRunnable) {
        new Thread(executeRunnable).start();
    }

    private void executeInThreadPool(Runnable executeRunnable) {
        this.runAsyncDecodeTask(executeRunnable);
    }

    private void initAsyncTaskExcutor() {
        if (CommonServerParam.DECODER_THREAD_POOL_SIZE > 0) {
            ASYNC_EXECUTOR_POOL_SIZE = CommonServerParam.DECODER_THREAD_POOL_SIZE;
        }
        this.asyncDecodeOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncDecodeExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncDecodeOperationQueue);
    }

    private void runAsyncDecodeTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncDecodeExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogManager.LogError(logger, "[CommonFrameDecoderManager.runAsyncDecodeTask] Run async task to decode failed : " + e.getMessage());
        }
    }
}

