/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameclient;

import com.simba.common.common.frameclient.connection.NettyConnection;
import com.simba.common.common.log.LogManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class ClientIoHandler
extends IdleStateAwareChannelHandler {
    public static final String CHANNEL_CONNECT = "0";
    public static final String CHANNEL_DISCONNECT = "1";
    protected static final Logger logger = Logger.getLogger(ClientIoHandler.class);

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        try {
            NettyConnection connection = (NettyConnection)channel.getAttachment();
            if (connection == null) {
                return;
            }
            connection.onChannelConnected(channel);
            connection.channelStateChanged(CHANNEL_CONNECT, channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        try {
            NettyConnection connection = (NettyConnection)channel.getAttachment();
            if (connection == null) {
                return;
            }
            connection.channelStateChanged(CHANNEL_DISCONNECT, channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        IdleState state = e.getState();
        Channel channel = ctx.getChannel();
        try {
            NettyConnection connection = (NettyConnection)channel.getAttachment();
            if (connection == null) {
                return;
            }
            connection.channelIdleState(channel, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        Channel channel = ctx.getChannel();
        try {
            NettyConnection connection = (NettyConnection)channel.getAttachment();
            if (connection == null) {
                return;
            }
            connection.channelExceptionCaught(channel, cause);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            Object message = e.getMessage();
            Channel ch = ctx.getChannel();
            NettyConnection connection = (NettyConnection)ch.getAttachment();
            if (connection == null) {
                return;
            }
            connection.messageRecived(ch, message);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
        }
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
    }
}

