/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.frameclient;

import com.simba.common.common.frameclient.IBootstrapManager;
import com.simba.common.common.frameclient.IClient;
import com.simba.common.common.frameclient.OnReceivedEvent;
import com.simba.common.common.frameclient.connection.NettyConnection;
import com.simba.common.common.frameclient.connection.NettyEventHandler;
import com.simba.common.common.log.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;

public abstract class BaseClient
implements IClient,
NettyEventHandler {
    protected static final Logger logger = Logger.getLogger(BaseClient.class);
    private List<OnReceivedEvent> events = new ArrayList<OnReceivedEvent>();
    protected IBootstrapManager bootstrapManager;
    protected NettyConnection connection;
    protected String id;
    protected AtomicBoolean isInited = new AtomicBoolean(false);
    protected String name;
    protected String serverHost;
    protected int serverPort;

    @Override
    public void disconnect() {
        if (this.isConnected().booleanValue()) {
            this.connection.disconnect();
        }
    }

    @Override
    public void doReconnected() {
        this.connection.send(null, false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isConnected() {
        return this.connection != null && this.connection.isChannelConnected();
    }

    @Override
    public void onChannelClosed(Channel channel) {
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onConnectFailed() {
        LogManager.LogError(logger, "[BaseClient.onConnectFailed] Connected to server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "] Failed");
    }

    @Override
    public void onConnectionClosed() {
        LogManager.LogError(logger, "[BaseClient.onConnectionClosed] Close from server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "]");
    }

    @Override
    public void onConnectionOpen() {
        LogManager.LogDebug(logger, "[BaseClient.onConnectionOpen] Connected to server--[HOST:" + this.serverHost + "][PORT:" + this.serverPort + "]");
    }

    @Override
    public void start(String clientId, String serverHost, int serverPort, String clientName, IBootstrapManager bootstrapManager) {
        this.id = clientId;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.name = clientName;
        this.bootstrapManager = bootstrapManager;
        if (this.isInited()) {
            return;
        }
        this.init();
    }

    private void init() {
        if (this.isInited()) {
            return;
        }
        this.setInited(true);
        ClientBootstrap bootstrap = this.bootstrapManager.getClientBootstrap(this.name);
        if (bootstrap == null) {
            return;
        }
        this.connection = new NettyConnection(this.serverHost, this.serverPort, this, bootstrap);
    }

    @Override
    public void addDataReceivedEvent(OnReceivedEvent event) {
        this.events.add(event);
    }

    @Override
    public void messageReceived(Channel channel, Object message) {
        for (OnReceivedEvent event : this.events) {
            event.messageReceived(this.name, channel, message);
        }
    }

    private boolean isInited() {
        return this.isInited.get();
    }

    private void setInited(boolean res) {
        this.isInited.set(res);
    }
}

