/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.database.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.simba.common.common.database.bean.DateBean;
import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.bean.TableBean;
import com.simba.common.common.database.bean.TableInfo;
import com.simba.common.common.database.bean.TableRelation;
import com.simba.common.common.database.factory.DbOperator;
import com.simba.common.common.database.factory.DbOperatorFactory;
import com.simba.common.common.database.helper.IDatabaseHelper;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.utils.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;
import javax.servlet.jsp.jstl.sql.ResultSupport;
import org.apache.log4j.Logger;

public class MysqlDatabaseHelper
implements IDatabaseHelper {
    private static final Logger logger = Logger.getLogger(MysqlDatabaseHelper.class);
    private Gson gson = new GsonBuilder().serializeNulls().create();
    private String databaseName;
    private DbOperatorFactory factory;

    public MysqlDatabaseHelper(DbOperatorFactory _factory, String databaseName) {
        this.databaseName = databaseName;
        this.factory = _factory;
    }

    @Override
    public String GetDatabaseName() {
        return this.databaseName;
    }

    @Override
    public Boolean HeartBeat() {
        Boolean ret = false;
        try {
            DbOperator dbOperator = this.factory.createDbOperator();
            if (dbOperator == null) {
                return ret;
            }
            return dbOperator.isAvaiableConnection();
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "exception info : " + ex.getMessage());
            ret = false;
            return ret;
        }
    }

    @Override
    public DbPageData GetDataPage(String tableName, int pageSize, int currentPage, int count, String fields, Map<String, ParamBean> maps, String[] keywordColumns, String keywordValue, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys) {
        Result result;
        if (currentPage <= 0 || pageSize < 0) {
            return null;
        }
        DbPageData pageData = new DbPageData(count, pageSize);
        pageData.setCurrentPage(currentPage);
        if (count <= 0) {
            return pageData;
        }
        String sql = "select " + fields + " from " + tableName + " ";
        sql = sql + this.CreateConditionString(maps, keywordColumns, keywordValue, condition, isOrderDesc, orderColumns, group, having, ignoreKeys, false);
        if (pageSize != 0) {
            sql = sql + " limit " + (currentPage - 1) * pageSize + "," + pageSize;
        }
        if ((result = this.QueryDataTable(sql)) != null) {
            pageData.setPageData(result.getRows());
        }
        return pageData;
    }

    @Override
    public DbPageData GetDataPage(TableBean databases, int pageSize, int currentPage, int count, String fields, Map<String, ParamBean> maps, String[] keywordColumns, String keywordValue, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys) {
        Result result;
        if (currentPage <= 0 || pageSize < 0) {
            return null;
        }
        DbPageData pageData = new DbPageData(count, pageSize);
        pageData.setCurrentPage(currentPage);
        if (count <= 0) {
            return pageData;
        }
        String sql = this.GetQuerySql(databases, maps, keywordColumns, keywordValue, fields, condition, isOrderDesc, orderColumns, group, having, ignoreKeys);
        if (pageSize != 0) {
            sql = sql + " limit " + (currentPage - 1) * pageSize + "," + pageSize;
        }
        if ((result = this.QueryDataTable(sql)) != null) {
            pageData.setPageData(result.getRows());
        }
        return pageData;
    }

    @Override
    public Result GetAllData(String tableName, String fileds, Map<String, ParamBean> maps, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys) {
        if (StringUtil.isNull(fileds).booleanValue()) {
            fileds = "*";
        }
        String sql = "select " + fileds + " from " + tableName + " " + this.CreateConditionString(maps, null, null, condition, isOrderDesc, orderColumns, group, having, ignoreKeys, false);
        return this.QueryDataTable(sql);
    }

    @Override
    public Result GetAllData(TableBean databases, Map<String, ParamBean> maps, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys) {
        String fields = "";
        String sql = this.GetQuerySql(databases, maps, null, null, fields, condition, isOrderDesc, orderColumns, group, having, ignoreKeys);
        return this.QueryDataTable(sql);
    }

    @Override
    public int UpdateBySql(String sql) {
        if (StringUtil.isNull(sql).booleanValue()) {
            return 0;
        }
        return this.ExecuteUpdate(sql);
    }

    @Override
    public Result QueryBySql(String sql) {
        return this.QueryDataTable(sql);
    }

    @Override
    public int QueryByScalar(String sql) {
        if (StringUtil.isNull(sql).booleanValue()) {
            return 0;
        }
        return this.ExecuteScalar(sql);
    }

    @Override
    public int AddData(String tableName, Map<String, ParamBean> maps, boolean isIgnore) {
        if (maps != null && maps.size() != 0) {
            String sql = "insert ";
            if (isIgnore) {
                sql = sql + "ignore ";
            }
            sql = sql + "into " + tableName + "(";
            for (String key : maps.keySet()) {
                if (key == null || key.equals("")) continue;
                sql = sql + key + ",";
            }
            sql = sql.trim();
            sql = sql.substring(0, sql.length() - 1);
            sql = sql + ") values('";
            for (String key : maps.keySet()) {
                if (key == null || key.equals("")) continue;
                sql = sql + maps.get(key).getValue() + "','";
            }
            sql = sql.trim();
            sql = sql.substring(0, sql.length() - 2);
            sql = sql + ")";
            return this.ExecuteUpdate(sql);
        }
        return 0;
    }

    @Override
    public int BatchAddData(String tableName, List<Map<String, ParamBean>> list, int batchSize, int commitSize) {
        String sql = "insert ignore into %s(%s) values ?";
        int row = 0;
        ArrayList<String> valueList = new ArrayList<String>();
        if (list != null && list.size() != 0) {
            StringBuilder keySb = new StringBuilder();
            int j = 0;
            for (String key : list.get(0).keySet()) {
                keySb.append(key);
                keySb.append(",");
                ++j;
            }
            String keys = keySb.toString();
            keys = keys.substring(0, keys.length() - 1);
            String[] keyList = keys.split(",");
            sql = String.format(sql, tableName, keys);
            String values = "";
            int listCount = list.size();
            int itemCount = listCount / 100;
            if (itemCount == 0) {
                itemCount = 1;
            }
            for (int i = 0; i < listCount; ++i) {
                StringBuilder valueSb = new StringBuilder();
                Map<String, ParamBean> maps = list.get(i);
                valueSb.append("('");
                for (int k = 0; k < maps.size(); ++k) {
                    if (!maps.containsKey(keyList[k])) {
                        LogManager.LogError(logger, "\u6279\u91cf\u6dfb\u52a0\u6570\u636e\u9519\u8bef");
                        return 0;
                    }
                    String value = maps.get(keyList[k]).getValue().toString();
                    valueSb.append(value);
                    valueSb.append("','");
                }
                values = values + valueSb.toString();
                values = values.trim();
                values = values.substring(0, values.length() - 2);
                values = values + "),";
                if ((i + 1) % batchSize == 0 || i == list.size() - 1) {
                    valueList.add(values.substring(0, values.length() - 1));
                    values = "";
                }
                if (i % itemCount != 0) continue;
                int progress = i / itemCount;
                if (progress > 100) {
                    progress = 100;
                }
                LogManager.LogError(logger, "\u5904\u7406\u4e2d\u3002\u3002\u3002>>>>" + progress);
            }
        }
        row = this.ExecuteUpdateTrans(sql, valueList);
        return row;
    }

    @Override
    public int UpdateData(String tableName, Map<String, ParamBean> maps, String condition, String value) {
        String sql = "update " + tableName + " set";
        if (maps != null && maps.size() != 0) {
            for (String key : maps.keySet()) {
                if (maps.get(key).getValue() == null || maps.get(key).getValue().equals("")) continue;
                sql = sql + " " + key + "='" + maps.get(key).getValue() + "',";
            }
            sql = sql.trim();
            sql = sql.substring(0, sql.length() - 1);
        }
        if (condition != null && !condition.equals("")) {
            sql = sql + " where " + condition + "='" + value + "'";
        }
        return this.ExecuteUpdate(sql);
    }

    private int DeleteData(String tableName, Map<String, ParamBean> maps, String condition, String group, String having, String[] ignoreKeys) {
        String sql = "delete from " + tableName + this.CreateConditionString(maps, null, null, condition, false, null, group, having, ignoreKeys, false);
        return this.ExecuteUpdate(sql);
    }

    @Override
    public int DeleteDataForId(String tableName, String condition, String value) {
        HashMap<String, ParamBean> maps = new HashMap<String, ParamBean>();
        maps.put(condition, new ParamBean(value));
        return this.DeleteData(tableName, maps, null, null, null, null);
    }

    @Override
    public int DeleteDataForCondition(String tableName, Map<String, ParamBean> maps, String condition, String group, String having, String[] ignoreKeys) {
        return this.DeleteData(tableName, maps, condition, group, having, ignoreKeys);
    }

    @Override
    public boolean TruncateTable(String tableName) {
        String sql = "truncate " + tableName;
        return this.ExecuteUpdate(sql) >= 0;
    }

    @Override
    public int CreateTable(String tableName, List<String[]> list, String[] uniqueKey) {
        if (StringUtil.isNull(tableName).booleanValue()) {
            return 0;
        }
        String sql = "CREATE TABLE IF NOT EXISTS `" + tableName + "` (";
        sql = sql + "`id` int(11) NOT NULL AUTO_INCREMENT,";
        for (String[] item : list) {
            if (item[0].equals("id")) continue;
            sql = StringUtil.isNull(item[2]) != false ? sql + "`" + item[0] + "` " + item[1] + " " : sql + "`" + item[0] + "` " + item[1] + "(" + item[2] + ") ";
            sql = item[3].equals("NOT NULL") ? sql + "NOT NULL " : sql + item[3] + " ";
            sql = sql + ",";
        }
        sql = sql + "PRIMARY KEY(`id`),";
        sql = sql + "UNIQUE KEY `" + tableName + "_id_uindex` (`id`),";
        if (uniqueKey != null) {
            for (String key : uniqueKey) {
                sql = sql + "UNIQUE KEY `" + tableName + "_" + key + "_uindex` (`" + key + "`),";
            }
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + ") ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARSET = utf8";
        return this.ExecuteUpdate(sql);
    }

    @Override
    public int DeleteTable(String tableName) {
        String sql = "DROP TABLE IF EXISTS " + tableName;
        return this.ExecuteUpdate(sql);
    }

    @Override
    public boolean IsTableExit(String databaseName, String tableName) {
        String sql = "select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA='" + databaseName + "' and TABLE_NAME='" + tableName + "'";
        Result table = this.QueryBySql(sql);
        return table != null && table.getRowCount() > 0;
    }

    @Override
    public int GetCount(String tableName, Map<String, ParamBean> maps, String[] keywordColumns, String keywordValue, String condition, String group, String having, String[] ignoreKeys) {
        int count = 0;
        try {
            String sql = "select count(id) as count from ";
            sql = group != null && group != "" ? sql + "(select id from " + tableName + " " + this.CreateConditionString(maps, keywordColumns, keywordValue, condition, false, null, group, having, ignoreKeys, false) + ") tb" : sql + tableName + " " + this.CreateConditionString(maps, keywordColumns, keywordValue, condition, false, null, null, null, ignoreKeys, false);
            count = this.ExecuteScalar(sql);
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "GetCount error , please check your table:" + ex);
            count = 0;
        }
        return count;
    }

    private String GetQuerySql(TableBean bean, Map<String, ParamBean> maps, String[] keywordColumns, String keywordValue, String fields, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys) {
        if (bean == null) {
            return null;
        }
        List<TableInfo> infos = bean.getTables();
        if (infos == null) {
            return null;
        }
        List<TableRelation> relations = bean.getRelation();
        if (relations == null) {
            return null;
        }
        String fieldStr = "";
        String databaseStr = "";
        for (TableInfo info : infos) {
            if (info.getFields() != null && info.getFields().length > 0) {
                for (String field : info.getFields()) {
                    fieldStr = fieldStr + info.getAlias() + "." + field + ",";
                }
            }
            if (info.getOtherFields() != null && info.getOtherFields().length > 0) {
                for (String field : info.getOtherFields()) {
                    fieldStr = fieldStr + field + ",";
                }
            }
            databaseStr = databaseStr + info.getTableName() + " " + info.getAlias() + ",";
        }
        databaseStr = databaseStr.substring(0, databaseStr.length() - 1);
        fieldStr = fieldStr.equals("") ? "*" : fieldStr.substring(0, fieldStr.length() - 1);
        String sql = "select " + fieldStr + " from " + databaseStr;
        String conStr = "";
        for (TableRelation relation : relations) {
            conStr = conStr + relation.getRelation() + " and";
        }
        condition = StringUtil.isNull(condition) != false ? conStr.substring(0, conStr.length() - 3) + " " : conStr + " " + condition;
        sql = sql + this.CreateConditionString(maps, null, null, condition, isOrderDesc, orderColumns, group, having, ignoreKeys, false);
        return sql;
    }

    private String CreateConditionString(Map<String, ParamBean> maps, String[] keywordColumns, String keywordValue, String condition, boolean isOrderDesc, String[] orderColumns, String group, String having, String[] ignoreKeys, boolean isMore) {
        String sql = " where";
        boolean hasCondition = false;
        if (!StringUtil.isNull(keywordValue).booleanValue() && keywordColumns != null && keywordColumns.length > 0) {
            sql = sql + " " + this.GetSearchKeyboardCondition(keywordColumns, keywordValue) + " and";
            hasCondition = true;
        }
        if (condition != null && condition != "") {
            sql = sql + " " + condition + " and";
            hasCondition = true;
        }
        if (maps != null && maps.size() > 0) {
            sql = sql + " 1=1 and";
            for (String key : maps.keySet()) {
                ParamBean param;
                boolean isIgnore = false;
                if (ignoreKeys != null && ignoreKeys.length > 0) {
                    for (String ignoreKey : ignoreKeys) {
                        if (!ignoreKey.equals(key)) continue;
                        isIgnore = true;
                        break;
                    }
                }
                if (isIgnore || !maps.containsKey(key) || maps.get(key) == null || (param = maps.get(key)).getValue() == null) continue;
                if (param.getType() == 1 || param.getType() == 3) {
                    Iterator values;
                    sql = sql + " (";
                    if (param.getType() == 1) {
                        for (Object roleId : values = (String[])param.getValue()) {
                            if (((String)roleId).contains("*") || ((String)roleId).contains("_")) {
                                String role = ((String)roleId).replace("*", "%");
                                sql = sql + this.getKey(key, param.getPrefix(), isMore) + " like '" + role + "' OR ";
                                continue;
                            }
                            sql = sql + this.getKey(key, param.getPrefix(), isMore) + " = " + (String)roleId + " OR ";
                        }
                        sql = ((Object)values).length > 0 ? sql.substring(0, sql.length() - 3) : sql + "1=2";
                    } else {
                        values = (List)param.getValue();
                        Iterator iterator = values.iterator();
                        while (iterator.hasNext()) {
                            String roleId = (String)iterator.next();
                            if (roleId.contains("*") || roleId.contains("_")) {
                                String role = roleId.replace("*", "%");
                                sql = sql + this.getKey(key, param.getPrefix(), isMore) + " like '" + role + "' OR ";
                                continue;
                            }
                            sql = sql + this.getKey(key, param.getPrefix(), isMore) + " = " + roleId + " OR ";
                        }
                        sql = values.size() > 0 ? sql.substring(0, sql.length() - 3) : sql + "1=2";
                    }
                    sql = sql + ") and";
                    continue;
                }
                if (param.getType() == 2) {
                    DateBean bean = (DateBean)this.gson.fromJson(this.gson.toJson(param.getValue()), new TypeToken<DateBean>(){}.getType());
                    if (bean.getBeginDate() != null && !bean.getBeginDate().equals("")) {
                        sql = sql + " " + this.getKey(key, param.getPrefix(), isMore) + ">='" + bean.getBeginDate() + "' and";
                    }
                    if (bean.getEndDate() == null || bean.getEndDate().equals("")) continue;
                    sql = sql + " " + this.getKey(key, param.getPrefix(), isMore) + "<='" + bean.getEndDate() + "' and";
                    continue;
                }
                if (param.getType() != 0) continue;
                String value = param.getValue().toString();
                if (value.contains("*") || value.contains("_")) {
                    String role = value.replace("*", "%");
                    sql = sql + " " + this.getKey(key, param.getPrefix(), isMore) + " like '" + role + "' and";
                    continue;
                }
                sql = sql + " " + this.getKey(key, param.getPrefix(), isMore) + "='" + param.getValue() + "' and";
            }
            sql = sql.substring(0, sql.length() - 3);
        } else {
            sql = hasCondition ? sql.substring(0, sql.length() - 3) : sql.substring(0, sql.length() - 5);
        }
        if (group != null && group != "") {
            sql = sql + " group by " + group;
            if (having != null && having != "") {
                sql = sql + " having " + having;
            }
        }
        if (orderColumns != null) {
            sql = sql + " order by ";
            for (String column : orderColumns) {
                sql = sql + column + ",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql = isOrderDesc ? sql + " desc" : sql + " asc";
        }
        return sql;
    }

    private String getKey(String key, String prefix, boolean isMore) {
        if (StringUtil.isNull(prefix).booleanValue() || !isMore) {
            return key;
        }
        if (prefix.equals("master") || prefix.equals("deputy")) {
            return prefix + "." + key;
        }
        return "master." + key;
    }

    @Override
    public String GetSearchKeyboardCondition(String[] searchKeywords, String value) {
        if (searchKeywords == null || searchKeywords.length <= 0) {
            return "";
        }
        String condition = "(";
        for (String key : searchKeywords) {
            condition = condition + key + " LIKE '%" + value + "%' OR ";
        }
        condition = condition.substring(0, condition.length() - 2);
        condition = condition + ")";
        return condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result QueryDataTable(String sql) {
        Result dt = null;
        try (DbOperator dbOperator = null;){
            dbOperator = this.factory.createDbOperator();
            if (dbOperator == null) {
                Result result = null;
                return result;
            }
            dbOperator.prepareStatement(sql);
            ResultSet rSet = dbOperator.executeQuery();
            if (rSet == null) {
                Result result = null;
                return result;
            }
            dt = ResultSupport.toResult(rSet);
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ExecuteUpdate(String sql) {
        int row = 0;
        try (DbOperator dbOperator = null;){
            dbOperator = this.factory.createDbOperator();
            dbOperator.prepareStatement(sql);
            row = dbOperator.executeUpdate();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ExecuteUpdateTrans(String sql, List<String> list, int commitSize) {
        int row = 0;
        try (DbOperator dbOperator = null;){
            dbOperator = this.factory.createDbOperator();
            dbOperator.setAutoCommit(false);
            dbOperator.prepareStatement(sql);
            for (String value : list) {
                dbOperator.setString(1, value);
                dbOperator.addBatch();
            }
            dbOperator.executeBatch();
            dbOperator.commit();
            row = 1;
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ExecuteUpdateTrans(String sql, List<String> list) {
        int row = 0;
        DbOperator dbOperator = null;
        Statement stmt = null;
        try {
            dbOperator = this.factory.createDbOperator();
            dbOperator.setAutoCommit(false);
            Connection conn = dbOperator.getConnection();
            stmt = conn.createStatement();
            for (String value : list) {
                stmt.addBatch(sql.replace("?", value));
            }
            int[] results = stmt.executeBatch();
            dbOperator.commit();
            if (results != null && results.length > 0) {
                for (int result : results) {
                    row += result;
                }
            }
        }
        catch (Exception e) {
            row = -1;
            LogManager.LogError(logger, "batch update data error: " + e.getMessage());
            try {
                if (dbOperator != null) {
                    dbOperator.rollback();
                }
            }
            catch (Exception em) {
                em.printStackTrace();
            }
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (Exception ex) {
                    LogManager.LogError(logger, "AbstractDBOperator -- close statement error: " + ex);
                }
            }
            if (dbOperator != null) {
                dbOperator.close();
            }
        }
        return row;
    }

    private int ExecuteScalar(String sql) {
        int count = 0;
        try {
            Result result = this.QueryDataTable(sql);
            count = Integer.parseInt(result.getRows()[0].get(result.getColumnNames()[0]).toString());
        }
        catch (Exception e) {
            count = -1;
            LogManager.LogError(logger, "execute scalar data error: " + e.getMessage());
        }
        return count;
    }
}

