/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.database.factory;

import com.simba.common.common.database.factory.DbOperatorFactory;
import com.simba.common.common.database.factory.DbPool;
import com.simba.common.common.database.helper.IDatabaseHelper;
import com.simba.common.common.database.helper.MysqlDatabaseHelper;
import com.simba.common.common.database.type.DatabaseType;

public class DatabaseParams {
    public static final String FATAL_SQL_EXCEPTION = "Fatal error";
    public static final long HOUSE_KEPPING_SLEEP_TIME = 5000L;
    public static final long MAX_ACTIVE_TIMEA = 60000L;
    public static final int MAX_CONNECTION_COUNT = 500;
    public static final long MAX_CONNECTION_LIVE_TIME = 18000000L;
    public static final int MIN_CONNECTION_COUNT = 10;
    public static final long OVERLOAD_WITHOUT_REFUSAL_LIFE_TIME = 50000L;
    public static final int PROTOTYPE_COUNT = 10;
    public static final int RECENTLY_STARTED_THREHOLD = 40000;
    public static final int SIMULTANEOUS_BUILD_THROTTLE = 30;
    public static final boolean TRACE = false;
    public static final boolean VERBOSE = false;
    private String key;
    private DatabaseType type;
    private String alias = "";
    private String aliasPrefix = "simba-database-";
    private String databaseAddress = "";
    private String databaseHost = "";
    private String databaseName = "";
    private String databasePassword = "";
    private int databasePort = 3306;
    private String databaseSid = "";
    private String databaseUser = "";
    private String houseKeepingTestSql = "";
    private String jdbcDriver = "";
    private String jdbcURL = "";
    private IDatabaseHelper helper;

    public DatabaseParams(String key, DatabaseType type) {
        this.key = key;
        this.type = type;
    }

    public void Init() {
        this.CreateFactory();
    }

    public String getKey() {
        return this.key;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public IDatabaseHelper getHelper() {
        return this.helper;
    }

    private void CreateFactory() {
        DbPool dbPool = new DbPool(this);
        dbPool.init(true);
        DbOperatorFactory factory = new DbOperatorFactory(dbPool);
        this.helper = new MysqlDatabaseHelper(factory, this.getDatabaseName());
    }

    public void ShutDown() {
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public String getDatabaseAddress() {
        return this.databaseAddress;
    }

    public String getDatabaseHost() {
        return this.databaseHost;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public String getDatabaseSid() {
        return this.databaseSid;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public long getHouseKeepingSleepTime() {
        return 5000L;
    }

    public String getHouseKeepingTestSql() {
        return this.houseKeepingTestSql;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public void setDatabaseAddress(String databaseAddress) {
        this.databaseAddress = databaseAddress;
    }

    public void setDatabaseHost(String databaseHost) {
        this.databaseHost = databaseHost;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public void setDatabaseSid(String _databaseSid) {
        this.databaseSid = _databaseSid;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public void setHouseKeepingTestSql(String houseKeepingTestSql) {
        this.houseKeepingTestSql = houseKeepingTestSql;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }
}

