/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.common.database.dao;

import com.simba.common.common.database.DbHelper;
import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.database.helper.IDatabaseHelper;
import com.simba.common.common.utils.StringUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;

public abstract class DaoBaseClass
implements IDaoBaseClass {
    public IDatabaseHelper dbHelper = DbHelper.GetCurrentHelper();
    public static String COLUMN_ID = "id";
    public static String ALL_FIELD = "*";

    public DaoBaseClass() {
        if (!this.IsTableExit()) {
            DaoBaseClass dao = this;
            dao.CreateTable();
            if (this.IsTableExit()) {
                dao.CreateDefaultData();
            }
        }
    }

    public boolean IsTableExit() {
        if (this.dbHelper == null) {
            return false;
        }
        String databaseName = this.dbHelper.GetDatabaseName();
        if (StringUtil.isNull(databaseName).booleanValue()) {
            return false;
        }
        return this.dbHelper.IsTableExit(databaseName, this.GetDataBaseName());
    }

    @Override
    public Result GetAllData(Map<String, ParamBean> maps, String condition, String group, String having, String[] ignoreKeys, boolean isOrderDesc) {
        return this.dbHelper.GetAllData(this.GetDataBaseName(), null, maps, condition, isOrderDesc, this.GetOrderColumn(), group, having, ignoreKeys);
    }

    @Override
    public DbPageData GetDataByPage(int pageSize, int currentPage, int count, Map<String, ParamBean> maps, String keywords, String[] ignoreKeys, String group, String having, boolean isOrderDesc) {
        return this.dbHelper.GetDataPage(this.GetDataBaseName(), pageSize, currentPage, count, ALL_FIELD, maps, this.GetKeywordsColumn(), keywords, null, isOrderDesc, this.GetOrderColumn(), group, having, ignoreKeys);
    }

    @Override
    public int DeleteDataInfoById(String value) {
        return this.dbHelper.DeleteDataForId(this.GetDataBaseName(), COLUMN_ID, value);
    }

    @Override
    public int DeleteDataInfoByCondition(Map<String, ParamBean> maps, String condition, String group, String having, String[] ignoreKeys) {
        return this.dbHelper.DeleteDataForCondition(this.GetDataBaseName(), maps, condition, group, having, ignoreKeys);
    }

    @Override
    public int GetCountByCondition(Map<String, ParamBean> maps, String keywords, String condition, String[] ignoreKeys) {
        return this.dbHelper.GetCount(this.GetDataBaseName(), maps, this.GetKeywordsColumn(), keywords, condition, null, null, ignoreKeys);
    }

    @Override
    public int AddNewDataInfo(Map<String, ParamBean> maps) {
        return this.dbHelper.AddData(this.GetDataBaseName(), maps, false);
    }

    @Override
    public int AddIgnoreDataInfo(Map<String, ParamBean> maps, boolean isIgnore) {
        return this.dbHelper.AddData(this.GetDataBaseName(), maps, isIgnore);
    }

    @Override
    public int BatchAddData(List<Map<String, ParamBean>> list, int batchSize, int commitSize) {
        return this.dbHelper.BatchAddData(this.GetDataBaseName(), list, batchSize, commitSize);
    }

    @Override
    public int BatchAddData(List<Map<String, ParamBean>> list) {
        return this.BatchAddData(list, 500, 1000);
    }

    @Override
    public int UpdateDataById(Map<String, ParamBean> maps, String value) {
        return this.dbHelper.UpdateData(this.GetDataBaseName(), maps, COLUMN_ID, value);
    }

    @Override
    public int UpdateDataByCondition(Map<String, ParamBean> maps, String key, String value) {
        return this.dbHelper.UpdateData(this.GetDataBaseName(), maps, key, value);
    }

    @Override
    public int IsDataExist(Map<String, ParamBean> maps) {
        return this.dbHelper.GetCount(this.GetDataBaseName(), maps, null, null, null, null, null, null);
    }

    @Override
    public boolean TruncationData() {
        return this.dbHelper.TruncateTable(this.GetDataBaseName());
    }

    @Override
    public abstract String GetDataBaseName();

    @Override
    public abstract String[] GetKeywordsColumn();

    @Override
    public abstract String[] GetOrderColumn();

    @Override
    public String[] GetDateColumn() {
        return null;
    }

    @Override
    public String GetIdColumn() {
        return COLUMN_ID;
    }

    @Override
    public String GetStatisticsData(Map<String, ParamBean> maps, String keywords) {
        return null;
    }

    @Override
    public int CreateTable() {
        return 0;
    }

    @Override
    public void CreateDefaultData() {
    }
}

