/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.business.task;

import com.simba.common.business.data.SortDataProxy;
import com.simba.common.common.log.LogManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class SortDataRestoreTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SortDataRestoreTask.class);
    private final BlockingQueue<SortDataProxy> sortInfoResultQueue = new LinkedBlockingQueue<SortDataProxy>();

    public SortDataRestoreTask() {
        this.setName("Sort-Result-Resotre-Task");
    }

    public void offerSortResultToQueue(SortDataProxy sorterData) {
        if (sorterData == null) {
            return;
        }
        this.sortInfoResultQueue.offer(sorterData);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.updateSorterInfoList();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogManager.LogError(logger, "Restore sort result to database error: " + ex);
            }
        }
    }

    protected void updateSorterInfoList() throws InterruptedException {
        SortDataProxy sorterResult = this.sortInfoResultQueue.take();
        sorterResult.restoreSortData();
    }
}

