/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common;

import com.simba.common.CommonParam;
import com.simba.common.business.SorterParameter;
import com.simba.common.common.DefaultServerInfo;
import com.simba.common.common.log.LogHelper;
import com.simba.common.common.utils.XmlUtil;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.UUID;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class CommonServerParam {
    public static String ACCESS_LOG = "access.log";
    public static int CAR_NUMBER = 500;
    public static String CONFIG_XML_FILE = "etc" + CommonParam.PATH_SEP + "simba-server-config.xml";
    public static int DECODER_THREAD_POOL_SIZE = 10;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static String ERROR_LOG = "error.log";
    public static int EVENT_THREAD_POOL_SIZE = 5;
    public static final String FALSE_STRING = "false";
    public static int IO_THREAD_POOL_SIZE = 5;
    public static boolean IS_WINDOWS_SERVER = false;
    public static String LOG_PATH = "logs";
    public static String NEED_DEBUG = "false";
    public static final String SERVER_VERSION = "1.0";
    public static final String TRUE_STRING = "true";
    public static String VERBOSE_LOG = "verbose.log";
    private static DefaultServerInfo serverInfo;
    private static String UUID_FILE_NAME;
    private static int UUID_LENGTH;

    public static DefaultServerInfo getServerInfo() {
        return serverInfo;
    }

    public static void initGlobalConfiguration() {
        try {
            String os = System.getProperty("os.name");
            IS_WINDOWS_SERVER = os.substring(0, 3).equalsIgnoreCase("win");
            Document rootMessage = XmlUtil.getXmlDocFromFile(new File(CONFIG_XML_FILE));
            Element rootElement = rootMessage.getRootElement();
            CommonServerParam.initConnectionSectionConfiguration(rootElement);
            CommonServerParam.initGlobalSectionConfiguration(rootElement);
        }
        catch (Exception ex) {
            System.out.println("Init global common configuration " + CONFIG_XML_FILE + " error: " + ex);
            System.out.println("Server Started failed");
            System.exit(5000);
        }
    }

    public static void initRootLogger() {
        File fp = new File(LOG_PATH);
        if (fp.exists()) {
            boolean canWrite = fp.canWrite();
            if (!canWrite) {
                System.out.println("Fatal Error: Log path: " + LOG_PATH + " can't write");
                System.exit(5000);
            }
        } else if (!fp.mkdir()) {
            System.out.println("Fatal Error: Data path: " + LOG_PATH + " can't create");
            System.exit(5000);
        }
        String accessLogPath = LOG_PATH + CommonParam.PATH_SEP + ACCESS_LOG;
        String errorLogPath = LOG_PATH + CommonParam.PATH_SEP + ERROR_LOG;
        String verboseLogPath = LOG_PATH + CommonParam.PATH_SEP + VERBOSE_LOG;
        try {
            LogHelper.configureRootLog(CommonParam.LOG_MODE, verboseLogPath, accessLogPath, errorLogPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initServerId() {
        String serverId = "";
        File file = new File(UUID_FILE_NAME);
        try {
            if (file.exists()) {
                serverId = CommonServerParam.readServerId();
            }
            if (serverId.length() != UUID_LENGTH) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            serverId = UUID.randomUUID().toString();
            CommonServerParam.writeServerId(serverId);
        }
        serverInfo = new DefaultServerInfo(serverId);
    }

    public static String replaceSlash(String path) {
        String result = path;
        result = CommonParam.PATH_SEP.equals("\\") ? result.replaceAll("/", "\\\\") : result.replaceAll("\\\\", "/");
        if (result.substring(result.length() - 1).equals(CommonParam.PATH_SEP)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void writeServerId(String serverId) {
        try {
            RandomAccessFile raf = new RandomAccessFile(UUID_FILE_NAME, "rw");
            raf.writeUTF(serverId);
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initConnectionSectionConfiguration(Element rootElement) {
        Element connElement = rootElement.getChild("Connection");
        String frameServerAddress = connElement.getChild("frame-sorter-server").getAttribute("ip").getValue();
        serverInfo.setDefaultServerAddress(frameServerAddress);
        serverInfo.setDefaultServerPort(Integer.parseInt(connElement.getChild("frame-sorter-server").getAttribute("port").getValue()));
        String jsonServerAddress = connElement.getChild("json-content-server").getAttribute("ip").getValue();
        serverInfo.setJsonServerAddress(jsonServerAddress);
        serverInfo.setJsonServerPort(Integer.parseInt(connElement.getChild("json-content-server").getAttribute("port").getValue()));
        String delimiterServerAddress = connElement.getChild("delimiter-server").getAttribute("ip").getValue();
        serverInfo.setDelimiterServerAddress(delimiterServerAddress);
        serverInfo.setDelimiterServerPort(Integer.parseInt(connElement.getChild("delimiter-server").getAttribute("port").getValue()));
        String httpServerAddress = connElement.getChild("http-json-server").getAttribute("ip").getValue();
        serverInfo.setHttpServerAddress(httpServerAddress);
        serverInfo.setHttpServerPort(Integer.parseInt(connElement.getChild("http-json-server").getAttribute("port").getValue()));
    }

    private static void initGlobalSectionConfiguration(Element rootElement) throws Exception {
        Element globalElement = rootElement.getChild("Global");
        EVENT_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("event-threads").getText());
        IO_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("io-workers").getText());
        DECODER_THREAD_POOL_SIZE = Integer.parseInt(globalElement.getChild("decoder-workers").getText());
        CAR_NUMBER = Integer.parseInt(globalElement.getChild("car-number").getText());
        LOG_PATH = globalElement.getChild("log-path").getText();
        NEED_DEBUG = globalElement.getChild("need-debug").getText();
        String newThreadEachReq = globalElement.getChild("new-thread-each-request").getText();
        if (newThreadEachReq.equalsIgnoreCase(TRUE_STRING)) {
            SorterParameter.getInstance().setNewThreadEachRequest(true);
        } else {
            SorterParameter.getInstance().setNewThreadEachRequest(false);
        }
    }

    private static String readServerId() throws Exception {
        RandomAccessFile raf = new RandomAccessFile(UUID_FILE_NAME, "r");
        String serverId = raf.readUTF();
        raf.close();
        return serverId;
    }

    static {
        UUID_FILE_NAME = "etc" + CommonParam.PATH_SEP + "uuid";
        UUID_LENGTH = 36;
    }
}

