/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common;

import com.simba.common.CommonParam;
import com.simba.common.CommonServerParam;
import com.simba.common.business.SorterParameter;
import com.simba.common.business.task.SortDataRestoreTask;
import com.simba.common.common.database.DbManager;
import com.simba.common.common.frameserver.FrameChannelHandler;
import com.simba.common.common.frameserver.FrameChannelManager;
import com.simba.common.common.frameserver.FrameServer;
import com.simba.common.common.httpserver.HttpChannelHandler;
import com.simba.common.common.httpserver.HttpChannelManager;
import com.simba.common.common.httpserver.HttpServer;
import com.simba.common.common.jsonserver.JsonChannelHandler;
import com.simba.common.common.jsonserver.JsonChannelManager;
import com.simba.common.common.jsonserver.JsonServer;
import com.simba.common.common.log.LogHelper;
import com.simba.common.common.log.LogManager;
import com.simba.common.common.processor.FrameProcessor;
import com.simba.common.common.processor.HttpProcessor;
import com.simba.common.common.processor.JsonProcessor;
import com.simba.common.common.utils.XmlUtil;
import com.simba.common.dataclient.DataClientManager;
import com.simba.common.framedecoder.CommonFrameDecoderManager;
import com.simba.common.httpservice.CommonHttpServiceManager;
import com.simba.common.jsonservice.CommonJsonServiceManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class CommonManager {
    public static final String MYSQL_CONFIG_FILE = "simba-mysql-config.xml";
    private static final String DATA_CLIENT_CONFIG_FILE = "simba-data-config.xml";
    private static final String LOG_HEADERS_CONFIG_FILE = "simba-log-header.xml";
    private static final Logger logger = Logger.getLogger(CommonManager.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FrameServer frameServer;
    private HttpServer httpServer;
    private JsonServer jsonServer;
    private int serialNumber;
    private final SortDataRestoreTask sortDataRestoreTask = new SortDataRestoreTask();

    public SimpleDateFormat getDateformat() {
        return this.dateFormat;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public SortDataRestoreTask getSortDataRestoreTask() {
        return this.sortDataRestoreTask;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void init() {
        this.initParam();
        this.initDatabase();
        this.initServerInstance();
        this.buildAllServers();
        this.startSingleThreadTasks();
        this.initBaseServers();
        this.postInitProcess();
    }

    private void initParam() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        CommonServerParam.initRootLogger();
        CommonServerParam.initServerId();
        CommonServerParam.initGlobalConfiguration();
        CommonServerParam.initRootLogger();
    }

    private void buildFrameServer() {
        System.out.println("[Server Init] Starting the tcp common of frame message ...");
        try {
            FrameProcessor frameMessageProcessor = new FrameProcessor(this.getFrameDecoderManager(), FrameChannelManager.getInstance());
            FrameChannelHandler handler = new FrameChannelHandler(frameMessageProcessor);
            this.frameServer = new FrameServer(CommonServerParam.getServerInfo().getDefaultServerAddress(), CommonServerParam.getServerInfo().getDefaultServerPort(), CommonServerParam.IO_THREAD_POOL_SIZE, CommonServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.frameServer.start();
            String printInfo = "[Server Init] Starting the frame sorter common on: " + this.frameServer.getInetSocketAddress().toString();
            LogManager.LogInfo(logger, printInfo);
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void buildHttpServer() {
        System.out.println("[Server Init] Starting the http common for http-json-data ...");
        try {
            HttpProcessor httpMessageProcessor = new HttpProcessor(this.getHttpServiceManager(), HttpChannelManager.getInstance());
            HttpChannelHandler handler = new HttpChannelHandler(httpMessageProcessor);
            this.httpServer = new HttpServer(CommonServerParam.getServerInfo().getHttpServerAddress(), CommonServerParam.getServerInfo().getHttpServerPort(), CommonServerParam.IO_THREAD_POOL_SIZE, CommonServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.httpServer.start();
            String printInfo = "[Server Init] Starting the http common on: " + this.httpServer.getInetSocketAddress().toString();
            LogManager.LogInfo(logger, printInfo);
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void buildJsonServer() {
        System.out.println("[Server Init] Starting the json common for services ...");
        try {
            JsonProcessor jsonMessageProcessor = new JsonProcessor(this.getJsonServiceManager(), JsonChannelManager.getInstance());
            JsonChannelHandler handler = new JsonChannelHandler(jsonMessageProcessor);
            this.jsonServer = new JsonServer(CommonServerParam.getServerInfo().getJsonServerAddress(), CommonServerParam.getServerInfo().getJsonServerPort(), CommonServerParam.IO_THREAD_POOL_SIZE, CommonServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.jsonServer.start();
            String printInfo = "[Server Init] Starting the json common on: " + this.jsonServer.getInetSocketAddress().toString();
            LogManager.LogInfo(logger, printInfo);
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void initSendHeaders() {
        try {
            Document rootDoc = XmlUtil.getXmlDocFromFile(new File("etc" + CommonParam.PATH_SEP + LOG_HEADERS_CONFIG_FILE));
            Element root = rootDoc.getRootElement();
            Element headersElement = root.getChild("Headers");
            List<Element> headers = headersElement.getChildren();
            for (Element element : headers) {
                String value = element.getAttributeValue("value");
                FrameChannelManager.getInstance().addHeader(value);
            }
        }
        catch (Exception ex) {
            LogManager.LogError(logger, "Send headers init error : " + ex.getMessage());
        }
    }

    private void initDatabaseMySQL() {
        DbManager.GetInstance().Init();
    }

    private void initDatabase() {
        this.initDatabaseMySQL();
    }

    private void startSingleThreadTasks() {
        this.getSortDataRestoreTask().start();
    }

    private void initServerInstance() {
        this.initFrameDecodeManager();
        this.initJsonServiceManager();
        this.initHttpServiceManager();
        this.initSorterParameters();
        this.initDataClientManager();
        this.initSendHeaders();
    }

    private void buildAllServers() {
        this.buildFrameServer();
        this.buildJsonServer();
        this.buildHttpServer();
    }

    private void initDataClientManager() {
        DataClientManager.getInstance().init(CommonServerParam.CONFIG_XML_FILE);
    }

    private void initSorterParameters() {
        SorterParameter.getInstance().initSortParams();
    }

    private void postInitProcess() {
        this.getFrameDecoderManager().postInitProcess();
        this.getHttpServiceManager().postInitProcess();
        this.getJsonServiceManager().postInitProcess();
    }

    private void initFrameDecodeManager() {
        this.getFrameDecoderManager().init();
    }

    private void initHttpServiceManager() {
        this.getHttpServiceManager().init();
    }

    private void initJsonServiceManager() {
        this.getJsonServiceManager().init();
    }

    public abstract void initBaseServers();

    public abstract CommonFrameDecoderManager getFrameDecoderManager();

    public abstract CommonHttpServiceManager getHttpServiceManager();

    public abstract CommonJsonServiceManager getJsonServiceManager();
}

