/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.server.components.SorterParams;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAEncrypt {
    private static Map<Integer, String> keyMap = new HashMap<Integer, String>();
    private static String KEY_RSA_TYPE = "RSA";
    private static int KEY_SIZE = 1024;
    private static int ENCODE_PART_SIZE = KEY_SIZE / 8;
    public static final String PUBLIC_KEY_NAME = "public";
    public static final String PRIVATE_KEY_NAME = "private";

    public static void genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = new String(Base64.encodeBase64(publicKey.getEncoded()));
        String privateKeyString = new String(Base64.encodeBase64(privateKey.getEncoded()));
        keyMap.put(0, publicKeyString);
        keyMap.put(1, privateKeyString);
    }

    public static String getToken() {
        String outStr = "";
        try {
            String timeBegin = String.valueOf(System.currentTimeMillis());
            String publicKey = SorterParams.getInstance().getPublicKey();
            String strCompanyName = SorterParams.getInstance().getCompany();
            String time = String.valueOf(System.currentTimeMillis());
            String message = strCompanyName + "-" + time;
            byte[] decoded = Base64.decodeBase64(publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            outStr = Base64.encodeBase64String(cipher.doFinal(message.getBytes("UTF-8")));
            String timeEnd = String.valueOf(System.currentTimeMillis());
            long costMillSeconds = Long.parseLong(timeEnd) - Long.parseLong(timeBegin);
            if (outStr.length() < 50) {
                System.out.println("gen token failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outStr;
    }

    public static String decrypt(String str, String privateKey) throws Exception {
        byte[] inputByte = Base64.decodeBase64(str.getBytes("UTF-8"));
        byte[] decoded = Base64.decodeBase64(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }
}

