/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.BoxInfo;
import org.apache.log4j.Logger;

public class BoxPackOfferTask
extends Thread {
    private static final Logger logger = Logger.getLogger(BoxPackOfferTask.class);
    private static final int REQUEST_INTERVAL = 1000;

    public BoxPackOfferTask() {
        this.setName("Box-Pack-Offer-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogUtil.LogError(logger, "Catch an exception [" + ex.getMessage() + "]");
            }
        }
    }

    private void getUploadBoxInfo() {
        BoxInfo boxInfo = new BoxInfo();
        ICommand command = CommandCreator.getInstance().createCommand("FetchBoxPackCmd", boxInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (!ret.booleanValue()) {
            return;
        }
        if (boxInfo.getBoxCode() == null || boxInfo.getBoxCode().equals("")) {
            return;
        }
        int uploadNum = boxInfo.getUploadNum() + 1;
        boxInfo.setUploadNum(uploadNum);
        boxInfo.setUploadFlag(1);
        command = CommandCreator.getInstance().createCommand("WebBoxPackCmd", boxInfo);
        ret = WebCommandExecutor.getInstance().executeCmd(command);
        if (!ret.booleanValue()) {
            boxInfo.setUploadFlag(0);
        }
        command = CommandCreator.getInstance().createCommand("RenewBoxPackCmd", boxInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

