/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.common.frameclient.IClient;
import com.simba.common.frameclient.IClientCreator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import org.apache.log4j.Logger;

public class DefaultClientCreator
implements IClientCreator {
    protected static final Logger logger = Logger.getLogger(DefaultClientCreator.class);

    public static IClientCreator getInstance() {
        return ClientCreatorHolder.INSTANCE;
    }

    private DefaultClientCreator() {
    }

    @Override
    public IClient createClient(String clientName) {
        IClient client = null;
        String packageName = "com.simba.server.netclient.Client";
        String className = packageName + clientName;
        try {
            Class<?> clazz = Class.forName(className);
            client = (IClient)clazz.newInstance();
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DefaultClientCreator.createClient] Create Client Error:" + e.getMessage(), 2));
            client = null;
        }
        return client;
    }

    private static class ClientCreatorHolder {
        private static final IClientCreator INSTANCE = new DefaultClientCreator();

        private ClientCreatorHolder() {
        }
    }
}

