/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.common.frameclient.ClientIoHandler;
import com.simba.common.frameclient.IBootstrapManager;
import com.simba.common.frameclient.connection.FrameClientPipelineFactory;
import com.simba.common.thread.CounterThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class DefaultBootstrapManager
implements IBootstrapManager {
    protected static final Logger logger = Logger.getLogger(DefaultBootstrapManager.class);
    private static final int EVENT_THREAD_POOL_SIZE = 2;
    private static final int IO_THREAD_POOL_SIZE = 2;
    private final ChannelUpstreamHandler clientIoHandler = new ClientIoHandler();
    private ClientBootstrap enderBootstrap;

    public static IBootstrapManager getInstance() {
        return BootstrapManagerHolder.INSTANCE;
    }

    private DefaultBootstrapManager() {
    }

    @Override
    public ClientBootstrap getClientBootstrap(String clientName) {
        ClientBootstrap bootstrap = null;
        switch (clientName) {
            case "Yuntu": {
                bootstrap = this.enderBootstrap;
                break;
            }
        }
        return bootstrap;
    }

    @Override
    public void init() {
        this.initYundaBootstrap();
    }

    private void initYundaBootstrap() {
        try {
            ExecutorService bossExecutor = Executors.newCachedThreadPool();
            MemoryAwareThreadPoolExecutor workerExecutor = new MemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("Camera Client Worker Thread "));
            OrderedMemoryAwareThreadPoolExecutor eventExecutor = new OrderedMemoryAwareThreadPoolExecutor(2, 0L, 0L, 300L, TimeUnit.SECONDS, (ThreadFactory)new CounterThreadFactory("CameraClient Event Thread "));
            this.enderBootstrap = new ClientBootstrap(new NioClientSocketChannelFactory((Executor)bossExecutor, workerExecutor, 2));
            this.enderBootstrap.setPipelineFactory(new FrameClientPipelineFactory(eventExecutor, this.clientIoHandler));
            this.setSocketOptions(this.enderBootstrap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setSocketOptions(ClientBootstrap bootstrap) {
        bootstrap.setOption("reuseAddress", true);
        bootstrap.setOption("child.reuseAddress", true);
        bootstrap.setOption("writeBufferHighWaterMark", 65536);
        bootstrap.setOption("writeBufferLowWaterMark", 32768);
        bootstrap.setOption("child.tcpNoDelay", true);
        bootstrap.setOption("child.keepAlive", true);
        bootstrap.setOption("child.sendBufferSize", 65536);
        bootstrap.setOption("child.receiveBufferSize", 65536);
    }

    private static class BootstrapManagerHolder {
        private static final IBootstrapManager INSTANCE = new DefaultBootstrapManager();

        private BootstrapManagerHolder() {
        }
    }
}

