/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.common.decoder.DecoderContainer;
import com.simba.common.decoder.DefaultDecoderContainer;
import com.simba.common.frameclient.BaseClient;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.ScreenInfoManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ClientYuntu
extends BaseClient {
    private static final Logger logger = Logger.getLogger(ClientYuntu.class);
    private final DecoderContainer decoderContainer = new DefaultDecoderContainer();

    @Override
    public void messageReceived(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            String jsonString = new String(content, "UTF-8");
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DataClient.messageReceived] Received invalid data messge : " + jsonString, 1));
            JSONTokener jsonTokener = new JSONTokener(jsonString);
            JSONObject contentObj = (JSONObject)jsonTokener.nextValue();
            String serviceName = contentObj.getString("ServiceName");
            if (serviceName == null || serviceName.equals("")) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DataClient.messageReceived] Received invalid data messge : " + jsonString, 2));
                return;
            }
            switch (serviceName) {
                case "Emergency": {
                    ScreenInfoManager.getInstance().emergencyDisplayMessage(contentObj);
                    break;
                }
                case "Chute": {
                    ScreenInfoManager.getInstance().chuteSlotStatus(contentObj);
                    break;
                }
                case "TEXT": {
                    ScreenInfoManager.getInstance().sortingScheme("TEST");
                    break;
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientYunda.messageReceived] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public void send(byte[] content) {
        try {
            if (content == null || content.length == 0) {
                return;
            }
            int contentLen = content.length + 2;
            byte[] sendBuffer = new byte[contentLen];
            sendBuffer[0] = 2;
            sendBuffer[contentLen - 1] = 3;
            System.arraycopy(content, 0, sendBuffer, 1, contentLen - 2);
            this.connection.send(sendBuffer, false);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientYunda.send]  : " + new String(sendBuffer, "UTF-8"), 3));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientYunda.send] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public void onChannelClosed(Channel channel) {
    }

    private void handleCPMessage(String sortContent) {
        String[] splitMessage = sortContent.split(":");
        String messageName = splitMessage[0];
        String resPonse = "ACK-" + messageName;
        this.send(resPonse.getBytes());
        String messageBody = splitMessage[1];
        Object dataObj = null;
    }

    private void handlePINGMessage(String sortContent) {
        String response = "PONG";
        this.send(response.getBytes());
    }

    private void handleSTMessage(String sortContent) {
        String[] splitMessage = sortContent.split(":");
        String messageName = splitMessage[0];
        String response = "ACK-" + messageName;
        this.send(response.getBytes());
        String messageBody = splitMessage[1];
        try {
            JSONObject requestObj = new JSONObject();
            String[] mesType = messageBody.split(",");
            String slotFlag = mesType[0];
            requestObj.put("slotFlag", slotFlag);
            String barcode = mesType[1];
            requestObj.put("barcode", barcode);
            String platId = mesType[2];
            requestObj.put("platId", platId);
            String slotsContent = mesType[3];
            requestObj.put("slotsContent", slotsContent);
            String recvTime = mesType[4];
            requestObj.put("recvTime", recvTime);
            String logicSlot = "0";
            if (mesType.length >= 6) {
                logicSlot = mesType[5];
            }
            requestObj.put("logicSlot", logicSlot);
            String businessType = "0";
            if (mesType.length >= 7) {
                businessType = mesType[6];
            }
            requestObj.put("businessType", businessType);
            requestObj.put("weight", "0");
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[Method]:[ClientYunda.handleSTMessage] , error:" + ex.getMessage() + "]", 2));
        }
    }
}

