/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class SlotsPackJsonService
implements JsonService {
    public static final String NAME = "SlotPack";
    private static final Logger logger = Logger.getLogger(SlotsPackJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            SlotInfo[] slotInfoList;
            JSONObject request = (JSONObject)content;
            String slotsDistrict = request.getString("slotsDistrict");
            int district = Integer.parseInt(slotsDistrict);
            for (SlotInfo slotInfo : slotInfoList = SlotManager.getInstance().getSlotInfoList()) {
                if (slotInfo.getSlotDistrict() != district) continue;
                SortControllerManager.getInstance().onSlotPackMessage(slotInfo);
            }
            Timestamp clearTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            LogUtil.LogDebug(logger, "Slots Pack Json Service request name : " + clearTime.toString());
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "SlotsPack Json Service Error : " + ex.getMessage());
        }
    }
}

