/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.StringUtil;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class MesHeartBeatJsonService
implements JsonService {
    public static final String NAME = "MesHeartBeat";
    private static final Logger logger = Logger.getLogger(MesHeartBeatJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            this.handleMesHeartBeat(channel, request);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "Mes Heart Beat Service Error : exception info : " + e.getMessage());
        }
    }

    private void handleMesHeartBeat(Channel connection, JSONObject request) {
        String platId = request.getString("platId");
        if (StringUtil.isNull(platId).booleanValue()) {
            return;
        }
        PlatInstance platInstance = PlatManager.getInstance().getPlatById(platId);
        if (platInstance == null) {
            return;
        }
        int platMode = platInstance.getPlatMode();
        String platModeContent = "none";
        if (platMode == 1) {
            platModeContent = "AUTO";
        } else if (platMode == 3) {
            platModeContent = "MANUAL";
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("ServiceName", "ToMes");
        response.put("type", "heartbeat");
        response.put("mode", platModeContent);
        response.put("status", "running");
        JSONObject responseObj = new JSONObject(response);
        JsonChannelManager.getInstance().commitResponse(connection, responseObj.toString().getBytes(), false);
    }
}

