/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlatScannedDecoder
implements Decoder {
    public static final String NAME = "PlatScanned";
    protected static final Logger logger = Logger.getLogger(PlatScannedDecoder.class);
    private static final int BARCODE_LEN_POSITION = 5;
    private static final int BARCODE_POSITION = 6;
    private static final int PLAT_ID_POSITION = 3;
    private static final int PLAT_MODE_POSITION = 4;

    public static PlatScannedDecoder getInstance() {
        return DecoderHolder.INSTANCE;
    }

    private PlatScannedDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            byte platIdBinary = content[3];
            String platId = String.valueOf(platIdBinary);
            byte modeBinary = content[4];
            String mode = String.valueOf(modeBinary);
            byte barcodeLen = content[5];
            String barcode = new String(content, 6, (int)barcodeLen, "UTF-8");
            int plcIdLenPosition = 6 + barcodeLen;
            int plcIdPosition = 6 + barcodeLen + 1;
            byte plcIdLen = content[plcIdLenPosition];
            String plcId = new String(content, plcIdPosition, (int)plcIdLen, "UTF-8");
            JSONObject scannedObj = new JSONObject();
            scannedObj.put("platId", platId);
            scannedObj.put("platMode", mode);
            scannedObj.put("barcode", barcode);
            scannedObj.put("plcId", plcId);
            scannedObj.put("scannedMode", "PLC");
            scannedObj.put("scannedPlatType", "AUTO");
            PlatInstance plat = PlatManager.getInstance().getPlatById(platId);
            if (plat != null) {
                plat.handleScannedCommand(channel, scannedObj);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Plat Scanned Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class DecoderHolder {
        private static final PlatScannedDecoder INSTANCE = new PlatScannedDecoder();

        private DecoderHolder() {
        }
    }
}

