/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SorterParams;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class MachineErrorDecoder
implements Decoder {
    public static final String NAME = "MachineError";
    protected static final Logger logger = Logger.getLogger(MachineErrorDecoder.class);
    private static final int MACHINE_STATUS_POSITION = 3;
    private static final int MECHINE_PAUSE = 3;
    private static final int MECHINE_RUNNING = 5;
    private static final int MECHINE_STARTED = 1;
    private static final int MECHINE_STOPPED = 2;
    private static final int MECHINE_WAIT = 4;

    public static MachineErrorDecoder getInstance() {
        return MachineErrorDecoderHolder.INSTANCE;
    }

    private MachineErrorDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            byte machineStatus = content[3];
            switch (machineStatus) {
                case 1: {
                    SorterParams.getInstance().setMachineStatus("starting");
                    break;
                }
                case 2: {
                    SorterParams.getInstance().setMachineStatus("stopping");
                    break;
                }
                case 3: {
                    SorterParams.getInstance().setMachineStatus("stopping");
                    break;
                }
                case 4: {
                    SorterParams.getInstance().setMachineStatus("waiting");
                    break;
                }
                case 5: {
                    SorterParams.getInstance().setMachineStatus("running");
                    break;
                }
                default: {
                    SorterParams.getInstance().setMachineStatus("none");
                    break;
                }
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "MachineStatus Decode Catch Exception : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return null;
    }

    private static class MachineErrorDecoderHolder {
        private static MachineErrorDecoder INSTANCE = new MachineErrorDecoder();

        private MachineErrorDecoderHolder() {
        }
    }
}

