/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.EmergencyStopInfo;
import com.simba.server.framedecoder.decoders.PacketOnDecoder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class EmergencyStopDecoder
implements Decoder {
    public static final String NAME = "EmergencyStop";
    protected static final Logger logger = Logger.getLogger(EmergencyStopDecoder.class);
    private static final int EMERGENCY_STOP_TOTAL = 4;
    private static final int EMERGENCY_STOP_PANEL_STATUS = 5;
    private static final int EMERGENCY_STOP_ONE_STATUS = 6;
    private static final int EMERGENCY_STOP_TWO_STATUS = 7;
    private static final int EMERGENCY_STOP_THREE_STATUS = 8;
    private static final int EMERGENCY_STOP_FOUR_STATUS = 9;
    private static final int EMERGENCY_STOP_FIVE_STATUS = 10;

    public static EmergencyStopDecoder getDecoderInstance() {
        return EmergencyStopDecoderHolder.INSTANCE;
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            byte[] content = (byte[])message;
            byte stopTotal = content[4];
            byte stopPanelStatus = content[5];
            byte stopOneStatus = content[6];
            byte stopTwoStatus = content[7];
            byte stopThreeStatus = content[8];
            byte stopFourStatus = content[9];
            byte stopFiveStatus = content[10];
            EmergencyStopInfo emergencyStopInfo = new EmergencyStopInfo();
            emergencyStopInfo.setStopTotal(stopTotal);
            emergencyStopInfo.setStopPanelStatus(stopPanelStatus);
            emergencyStopInfo.setStopOneStatus(stopOneStatus);
            emergencyStopInfo.setStopTwoStatus(stopTwoStatus);
            emergencyStopInfo.setStopThreeStatus(stopThreeStatus);
            emergencyStopInfo.setStopFourStatus(stopFourStatus);
            emergencyStopInfo.setStopFiveStatus(stopFiveStatus);
            SortControllerManager.getInstance().onEmergencyStopMessage(emergencyStopInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(PacketOnDecoder.logger, "PacketOn Decoder Error : exception info : " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class EmergencyStopDecoderHolder {
        private static final EmergencyStopDecoder INSTANCE = new EmergencyStopDecoder();

        private EmergencyStopDecoderHolder() {
        }
    }
}

